-- Filename: division_srt_radix2_calc_shifts_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Fri Oct 18 15:32:19 2024
architecture struct of division_srt_radix2_calc_shifts is
    signal quotient_too_big_by_shifts  : integer range g_shift_lower_limit to g_shift_upper_limit;
    signal remainder_too_big_by_shifts : integer range g_shift_lower_limit_rem to g_shift_upper_limit_rem;
begin
    quotient_too_big_by_shifts  <= g_dividend_width-1      -- This is the number of bits the binary point of the quotient must be shifted to the right.
                                 + number_of_shifts_dvd_i  -- The dividend was shifted to the left by this number, so the quotient was increased by the shift.
                                 - number_of_shifts_dvr_i; -- The divisor  was shifted to the left by this number, so the quotient was decreased by the shift.
    remainder_too_big_by_shifts <= number_of_shifts_dvd_i-1 when number_of_shifts_dvd_i>number_of_shifts_dvr_i else
                                   number_of_shifts_dvr_i;
    clocked_g: if g_latency_division/=0 generate
        process (res_i, clk_i)
        begin
            if res_i='1' then
                quotient_too_big_by_shifts_o  <= 0;
                remainder_too_big_by_shifts_o <= 0;
            elsif rising_edge(clk_i) then
                quotient_too_big_by_shifts_o  <= quotient_too_big_by_shifts;
                remainder_too_big_by_shifts_o <= remainder_too_big_by_shifts;
            end if;
        end process;
    end generate clocked_g;
    combinatorial_g: if g_latency_division=0 generate
        quotient_too_big_by_shifts_o  <= quotient_too_big_by_shifts;
        remainder_too_big_by_shifts_o <= remainder_too_big_by_shifts;
    end generate combinatorial_g;
end architecture;
