-- Filename: division_srt_radix2_fix_remainder_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Tue Sep 17 15:24:02 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of division_srt_radix2_fix_remainder is
begin
    process (remainder_pre_norm_i, sign_dividend_i, divisor_norm_i, number_of_shifts_dvd_i, number_of_shifts_dvr_i)
    begin
        if remainder_pre_norm_i=0 then
            remainder_norm_o <= (others => '0');
        else
            if remainder_pre_norm_i(g_op_width-1)/=sign_dividend_i then
                if remainder_pre_norm_i(g_op_width-1)/=divisor_norm_i(g_op_width-1) then
                    remainder_norm_o <= remainder_pre_norm_i + divisor_norm_i;
                else
                    remainder_norm_o <= remainder_pre_norm_i - divisor_norm_i;
                end if;
            else -- remainder_pre_norm_i and dividend have same sign
                if remainder_pre_norm_i=-divisor_norm_i and number_of_shifts_dvr_i+2>number_of_shifts_dvd_i then
                    remainder_norm_o <= (others => '0');
                else
                    remainder_norm_o <= remainder_pre_norm_i;
                end if;
            end if;
        end if;
    end process;
end architecture;
