-- Filename: division_srt_radix2_convert_e.vhd
-- Created by HDL-SCHEM-Editor at Tue Sep 17 15:24:01 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity division_srt_radix2_convert is
    generic (
        constant g_quotient_width: natural := 8;
        constant g_op_width      : natural := 8;
        constant g_latency       : natural := 1 
    );
    port (
        carry_vector_rem_i   : in  signed(g_op_width-2 downto 0);
        clk_i                : in  std_logic;
        quotient_minus_i     : in  unsigned(g_quotient_width-1 downto 0);
        quotient_plus_i      : in  unsigned(g_quotient_width-1 downto 0);
        res_i                : in  std_logic;
        start_i              : in  std_logic;
        xor_vector_rem_i     : in  signed(g_op_width-1 downto 0);
        quotient_norm_o      : out signed(g_quotient_width downto 0);
        ready_o              : out std_logic;
        remainder_pre_norm_o : out signed(g_op_width-1 downto 0)
    );
end entity division_srt_radix2_convert;
