-- Filename: division_srt_radix2_fix_remainder_e.vhd
-- Created by HDL-SCHEM-Editor at Tue Sep 17 15:24:02 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity division_srt_radix2_fix_remainder is
    generic (
        constant g_op_width : natural := 8;
        constant g_dividend_width : natural := 8;
        constant g_divisor_width : natural := 8 
    );
    port (
        divisor_norm_i         : in  signed(g_op_width-1 downto 0);
        number_of_shifts_dvd_i : in  natural range 0 to g_dividend_width-1;
        number_of_shifts_dvr_i : in  natural range 0 to g_divisor_width-1;
        remainder_pre_norm_i   : in  signed(g_op_width-1 downto 0);
        sign_dividend_i        : in  std_logic;
        remainder_norm_o       : out signed(g_op_width-1 downto 0)
    );
end entity division_srt_radix2_fix_remainder;
