-- Filename: division_srt_radix2_e.vhd
-- Created by HDL-SCHEM-Editor at Fri Oct 18 15:32:19 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity division_srt_radix2 is
    generic (
        constant g_dividend_width    : natural := 64;
        constant g_divisor_width     : natural := 64;
        constant g_add_quotient_bits : natural := 0;
        constant g_latency_division  : natural := 13;
        constant g_latency_convert   : natural := 1;
        constant g_latency_norm      : natural := 1;
        constant g_latency_denorm    : natural := 1 
    );
    port (
        clk_i      : in  std_logic;
        dividend_i : in  signed(g_dividend_width-1 downto 0);
        divisor_i  : in  signed(g_divisor_width-1 downto 0);
        res_i      : in  std_logic;
        start_i    : in  std_logic;
        quotient_o : out signed(g_dividend_width+g_add_quotient_bits downto 0);
        ready_o    : out std_logic;
        rem_o      : out signed(g_divisor_width-1 downto 0)
    );
end entity division_srt_radix2;
