-- Filename: division_srt_radix2_convert_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Tue Sep 17 15:24:01 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of division_srt_radix2_convert is
    signal quotient      : signed(g_quotient_width downto 0);
    signal remainder_pre : signed(g_op_width-1 downto 0);
begin
    -- When quotient_minus_i is subtracted from quotient_plus_i, a negative number can be the result, so a sign bit is needed:
    quotient      <= signed('0'&quotient_plus_i) - signed('0'&quotient_minus_i);
    remainder_pre <= xor_vector_rem_i + (carry_vector_rem_i&'0');
    clocked_g: if g_latency/=0 generate
        process (res_i, clk_i)
        begin
            if res_i='1' then
                ready_o <= '0';
                quotient_norm_o      <= (others => '0');
                remainder_pre_norm_o <= (others => '0');
            elsif rising_edge(clk_i) then
                ready_o <= start_i;
                if start_i='1' then
                    quotient_norm_o      <= quotient;
                    remainder_pre_norm_o <= remainder_pre;
                end if;
            end if;
        end process;
        
    end generate clocked_g;
    combinatorial_g: if g_latency=0 generate
        ready_o              <= start_i;
        quotient_norm_o      <= quotient;
        remainder_pre_norm_o <= remainder_pre;
    end generate combinatorial_g;
end architecture;
