-- Filename: division_srt_radix2_calc_shifts_e.vhd
-- Created by HDL-SCHEM-Editor at Fri Oct 18 15:32:19 2024
library ieee;
use ieee.std_logic_1164.all;
entity division_srt_radix2_calc_shifts is
    generic (
        constant g_dividend_width        : natural := 8;
        constant g_divisor_width         : natural := 8;
        constant g_shift_upper_limit     : integer := 8;
        constant g_shift_lower_limit     : integer := 0;
        constant g_shift_upper_limit_rem : integer := 8;
        constant g_shift_lower_limit_rem : integer := 0;
        constant g_latency_division      : integer := 0 
    );
    port (
        clk_i                         : in  std_logic := '0';
        number_of_shifts_dvd_i        : in  natural range 0 to g_dividend_width-1;
        number_of_shifts_dvr_i        : in  natural range 0 to g_divisor_width-1;
        res_i                         : in  std_logic;
        quotient_too_big_by_shifts_o  : out integer range g_shift_lower_limit to g_shift_upper_limit;
        remainder_too_big_by_shifts_o : out integer range g_shift_lower_limit_rem to g_shift_upper_limit_rem
    );
end entity division_srt_radix2_calc_shifts;
