-- Filename: division_signed_convert_e.vhd
-- Created by HDL-SCHEM-Editor at Sun Jun 23 20:06:40 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity division_signed_convert is
    generic (
        constant g_latency            : natural := 1;
        constant g_dividend_width     : natural := 8;
        constant g_dividend_width_ext : natural := 8;
        constant g_divisor_width      : natural := 4 
    );
    port (
        clk_i            : in  std_logic;
        divisor_i        : in  signed(g_divisor_width-1 downto 0);
        quotient_coded_i : in  std_logic_vector(g_dividend_width_ext-2 downto 0);
        remainder_i      : in  signed(g_divisor_width-1 downto 0);
        res_i            : in  std_logic;
        sign_dvd_i       : in  std_logic;
        start_i          : in  std_logic;
        quotient_o       : out signed(g_dividend_width downto 0);
        ready_o          : out std_logic;
        remainder_o      : out signed(g_divisor_width-1 downto 0)
    );
end entity division_signed_convert;
