// Filename: testbench_division.v
// Created by HDL-SCHEM-Editor at Wed Dec 18 18:28:43 2024
module testbench_division
    ;
    parameter c_period                    = 10;
    parameter c_dividend_width            = 8;
    parameter c_divisor_width             = 6;
    parameter c_latency_division_unsigned = 1;
    parameter c_latency_abs               = 1;
    parameter c_latency_fix_sign          = 1;

    integer dividend_int;
    integer divisor_int;

    initial
    begin
       $dumpfile("test.vcd");
       $dumpvars(0,testbench_division);
    end

    reg clk;
    reg res;
    reg signed [c_dividend_width-1:0] dividend;
    reg signed [c_divisor_width-1:0] divisor;
    reg start;
    wire ready;
    wire signed [c_dividend_width:0] quotient;
    wire signed [c_divisor_width-1:0] remainder;
    initial begin
        res = 1;
        #1 res = 0;
    end
    initial begin
        clk = 1;
        forever begin
            #(c_period/2) clk = ~clk;
        end
    end
    initial begin
        start    <= 0;
        dividend <= 0;
        divisor  <= 0;
        #c_period;
        #1;
        for (dividend_int = 2**(c_dividend_width-1)-1; dividend_int >= -(2**(c_dividend_width-1)); dividend_int = dividend_int-1) begin
        //for (dividend_int = 2**(c_dividend_width-1)-1; dividend_int == 2**(c_dividend_width-1)-1; dividend_int = dividend_int-1) begin
            for (divisor_int = 2**(c_divisor_width-1)-1; divisor_int >= -(2**(c_divisor_width-1)); divisor_int = divisor_int-1) begin
            //for (divisor_int = 2**(c_divisor_width-1)-1; divisor_int == 2**(c_divisor_width-1)-1; divisor_int = divisor_int-1) begin
                if (divisor_int!=0) begin
                    //$display("dividend_int = %0d", dividend_int);
                    //$display("divisor_int  = %0d", divisor_int);
                    dividend <= dividend_int;
                    divisor  <= divisor_int;
                    start <= 1;
                    #10 start <= 0;
                    while (ready!=1) begin
                        #c_period;
                    end
                    if (quotient!=dividend/divisor) begin
                        $display("Wrong quotient at time %0d", $time);
                    end
                    if (remainder!=dividend % divisor) begin
                        $display("Wrong quotient at time %0d", $time);
                    end
                    #1;
                    #c_period;
                end
            end
        end
        $finish();
    end
    
    division #(
        .g_dividend_width(c_dividend_width),
        .g_divisor_width(c_divisor_width),
        .g_latency_division_unsigned(c_latency_division_unsigned),
        .g_latency_abs(c_latency_abs),
        .g_latency_fix_sign(c_latency_fix_sign)
        ) division_inst (
        .clk_i      (clk),
        .dividend_i (dividend),
        .divisor_i  (divisor),
        .res_i      (res),
        .start_i    (start),
        .quotient_o (quotient),
        .ready_o    (ready),
        .rem_o      (remainder)
    );
endmodule
