// Filename: division_negate.v
// Created by HDL-SCHEM-Editor at Wed Dec 18 18:03:33 2024
module division_negate
    #(parameter
        g_latency       = 0,
        g_operand_width = 8
    )
    (
        input  [g_operand_width-1:0] unsigned_number_i,
        input  clk_i,
        input  negate_i,
        input  res_i,
        input  start_i,
        output reg ready_o,
        output reg signed [g_operand_width:0] signed_number_o
    );
    generate if (g_latency==0) 
        begin: combinatorial_g
            always @(*) begin
                ready_o <= start_i;
                signed_number_o <=  (negate_i==1'b0) ? unsigned_number_i : -unsigned_number_i;
            end
        end
    endgenerate
    generate if (g_latency!=0) 
        begin: clocked_g
            always @(posedge clk_i or posedge res_i) begin
                if (res_i==1) begin
                    ready_o <= 0;
                    signed_number_o <= 0;
                end else begin
                    ready_o <= start_i;
                    if (start_i==1'b1) begin
                        if (negate_i==1'b0)
                            signed_number_o <=  unsigned_number_i;
                        else
                            signed_number_o <= -unsigned_number_i;
                    end
                end
            end
        end
    endgenerate
endmodule
