// Filename: division_unsigned_step.v
// Created by HDL-SCHEM-Editor at Wed Dec 18 18:03:35 2024
module division_unsigned_step
    #(parameter
        g_divisor_width = 8
    )
    (
        input  [g_divisor_width-1:0] divisor_i,
        input  [g_divisor_width-1:0] interim_result_i,
        input  dividend_bit_i,
        input  quotient_bit_last_i,
        output wire [g_divisor_width-1:0] interim_result_o,
        output wire quotient_bit_o
    );
    reg [g_divisor_width:0] new_interim_result;
    wire [g_divisor_width:0] divisor;
    wire [g_divisor_width:0] interim_result;
    assign interim_result = {interim_result_i, dividend_bit_i};
    assign divisor        = {1'b0, divisor_i};
    always @(quotient_bit_last_i, interim_result, divisor)
    begin
        // "Restoring" division algorithm:
        if (quotient_bit_last_i==1'b1)
            new_interim_result <= interim_result - divisor;
        else
            new_interim_result <= interim_result + divisor;
    end
    assign quotient_bit_o   = ~ new_interim_result[g_divisor_width];
    assign interim_result_o =   new_interim_result[g_divisor_width-1:0];
    
endmodule
