// Filename: division_unsigned.v
// Created by HDL-SCHEM-Editor at Wed Dec 18 18:03:33 2024
module division_unsigned
    #(parameter
        g_latency        = 8,
        g_dividend_width = 8,
        g_divisor_width  = 4
    )
    (
        input  [g_dividend_width-1:0] dividend_i,
        input  [g_divisor_width-1:0] divisor_i,
        input  clk_i,
        input  res_i,
        input  start_i,
        output reg [g_dividend_width-1:0] quotient_o,
        output wire [g_divisor_width-1:0] rem_o,
        output wire ready_o
    );
    function integer ceil2;
        input real    value_real;
        input integer value_integer;
        real value_integer_as_real;
    begin
        value_integer_as_real = value_integer;
        if (value_real-value_integer_as_real>0)
            ceil2 = value_integer + 1;
        else
            ceil2 = value_integer;
    end
    endfunction

    localparam real g_dividend_width_real = g_dividend_width;
    localparam real g_latency_real        = g_latency;
    localparam g_dividend_width_by_g_latency_rounded = ceil2(g_dividend_width_real/g_latency_real, g_dividend_width/g_latency);

    localparam c_nr_of_steps        = (g_latency==0) ? g_dividend_width : g_dividend_width_by_g_latency_rounded;
    localparam c_dividend_width_ext = (g_latency==0) ? g_dividend_width : c_nr_of_steps * g_latency;
    localparam c_nr_of_periods      = c_dividend_width_ext/c_nr_of_steps;
    genvar i;
    integer k, n, s, p;
    integer index;
    reg [0:c_nr_of_steps-1] dividend_bits;
    reg [c_nr_of_periods-1:0] sr[c_nr_of_steps-1:0];
    reg [g_divisor_width-1:0] interim_result_reg;
    wire [c_dividend_width_ext-1:0] dividend;
    wire [c_nr_of_steps:0] quotient_bit;
    wire [g_divisor_width-1:0] interim_result[c_nr_of_steps:0];
    wire ready;
    wire reg_enable;
    division_unsigned_control #(
        .g_counter_max(c_nr_of_periods-1)
        ) division_unsigned_control_inst (
        .clk_i        (clk_i),
        .res_i        (res_i),
        .start_i      (start_i),
        .ready_o      (ready),
        .reg_enable_o (reg_enable)
    );
    assign dividend = dividend_i;
    always @(*) begin : mux
        if (start_i==1'b1 || g_latency==0 || g_latency==1) begin : init_div_bits
            for (k=0; k<=c_nr_of_steps-1; k=k+1) begin
                index = c_dividend_width_ext-1-k;
                dividend_bits[k] <= dividend[index];
            end
        end else
            for (k=0; k<=c_nr_of_steps-1; k=k+1) dividend_bits[k] <= sr[k][c_nr_of_periods-1];
    end
    assign interim_result[0] = (start_i==1'b1 || g_latency==0 || g_latency==1) ? 0 : interim_result_reg;
    assign quotient_bit  [0] = (start_i==1'b1 || g_latency==0 || g_latency==1) ? 1 : sr[c_nr_of_steps-1][0];
    generate for (i=0; i<=c_nr_of_steps-1; i=i+1) 
        begin: division_unsigned_step_g
            division_unsigned_step #(
                .g_divisor_width(g_divisor_width)
                ) division_unsigned_step_inst (
                .dividend_bit_i      (dividend_bits[i]),
                .divisor_i           (divisor_i),
                .interim_result_i    (interim_result[i]),
                .quotient_bit_last_i (quotient_bit[i]),
                .interim_result_o    (interim_result[i+1]),
                .quotient_bit_o      (quotient_bit[i+1])
            );
        end
    endgenerate
    always @(*)
    begin
        for (s=0; s<=c_nr_of_steps-1; s=s+1) begin
            for (p=c_nr_of_periods-1; p>=0; p=p-1) begin
                if (c_nr_of_steps*p+c_nr_of_steps-1-s<g_dividend_width)
                    quotient_o[c_nr_of_steps*p+c_nr_of_steps-1-s] <= sr[s][p];
            end
        end
    end
    generate if (g_latency!=0) 
        begin: clocked_g 
            assign ready_o = ready;
            always @(posedge res_i or posedge clk_i)
            begin
                if (res_i==1'b1) begin
                    for (k=0; k<=c_nr_of_steps-1;k=k+1) sr[k] <= {c_nr_of_periods {1'b0}};
                    interim_result_reg <= 0;
                end else begin
                    if (start_i==1) begin
                        for (k=0; k<=c_nr_of_steps-1; k=k+1) begin
                            for (n=c_nr_of_periods-1; n>=1; n=n-1) sr[k][n] <= dividend[n*c_nr_of_steps-1-k];
                            sr[k][0] <= quotient_bit[k+1];
                        end
                    end else begin
                        if (reg_enable==1) begin
                            for (k=0; k<=c_nr_of_steps-1; k=k+1) begin // Anzahl der Schieberegister = c_nr_of_steps
                                for (n=c_nr_of_periods-1; n>=1; n=n-1) sr[k][n] <= sr[k][n-1];
                                sr[k][0] <= quotient_bit[k+1];
                            end
                        end
                    end
                    if (start_i==1'b1 || reg_enable==1'b1) interim_result_reg <= interim_result[c_nr_of_steps];
                end
            end
            assign rem_o = sr[c_nr_of_steps-1][0]==1'b1 ? interim_result_reg : interim_result_reg + divisor_i;
        end
    endgenerate
    generate if (g_latency==0) 
        begin: combinatorial_g
            assign ready_o = start_i;
            always @(quotient_bit)
            begin
                for (k=0; k<=c_nr_of_steps-1; k=k+1) sr[k][0] <= quotient_bit[k+1];
            end
            assign rem_o = quotient_bit[c_nr_of_steps]==1'b1 ? interim_result[c_nr_of_steps] : interim_result[c_nr_of_steps] + divisor_i;
        end
    endgenerate
endmodule
