// Filename: division_abs.v
// Created by HDL-SCHEM-Editor at Wed Dec 18 18:03:33 2024
module division_abs
    #(parameter
        g_latency       = 0,
        g_operand_width = 8
    )
    (
        input  clk_i,
        input  res_i,
        input  signed [g_operand_width-1:0] signed_number_i,
        input  start_i,
        output reg [g_operand_width-1:0] unsigned_number_o,
        output reg ready_o,
        output reg sign_o
    );
    generate if (g_latency==0) 
        begin:  combinatorial_g
            always @(*)
            begin
                ready_o <= start_i;
                sign_o  <= signed_number_i[g_operand_width-1];
                unsigned_number_o <= signed_number_i[g_operand_width-1]==1'b0 ? signed_number_i : -signed_number_i;
            end
            
        end
    endgenerate
    generate if (g_latency!=0)
        begin: clocked_g
            always @(posedge res_i or posedge clk_i) begin
                if (res_i==1'b1) begin
                    ready_o           <= 0;
                    sign_o            <= 0;
                    unsigned_number_o <= 0;
                end else begin
                    ready_o <= start_i;
                    sign_o  <= signed_number_i[g_operand_width-1];
                    if (start_i==1'b1) begin
                        if (signed_number_i[g_operand_width-1]==1'b0)
                            unsigned_number_o <=  signed_number_i;
                        else
                            unsigned_number_o <= -signed_number_i;
                    end
                end
            end
        end
    endgenerate
endmodule
