// Filename: division.v
// Created by HDL-SCHEM-Editor at Wed Dec 18 18:30:36 2024
module division
    #(parameter
        g_latency_division_unsigned = 32,
        g_latency_abs               = 1,
        g_latency_fix_sign          = 1,
        g_dividend_width            = 32,
        g_divisor_width             = 32
    )
    (
        input  clk_i,
        input  res_i,
        input  signed [g_dividend_width-1:0] dividend_i,
        input  signed [g_divisor_width-1:0] divisor_i,
        input  start_i,
        output wire ready_o,
        output wire signed [g_dividend_width:0] quotient_o,
        output wire signed [g_divisor_width-1:0] rem_o
    );
    wire [g_dividend_width-1:0] dividend;
    wire [g_dividend_width-1:0] quotient;
    wire [g_divisor_width-1:0] divisor;
    wire [g_divisor_width-1:0] remainder_unsigned;
    wire dividend_sign;
    wire divisor_sign;
    wire negate;
    wire ready_abs;
    wire ready_div_unsigned;
    wire signed [g_divisor_width:0] remainder;
    division_abs #(
        .g_latency(g_latency_abs),
        .g_operand_width(g_dividend_width)
        ) division_abs_dvd_inst (
        .clk_i             (clk_i),
        .res_i             (res_i),
        .signed_number_i   (dividend_i),
        .start_i           (start_i),
        .ready_o           (),
        .sign_o            (dividend_sign),
        .unsigned_number_o (dividend)
    );
    division_abs #(
        .g_latency(g_latency_abs),
        .g_operand_width(g_divisor_width)
        ) division_abs_dvr_inst (
        .clk_i             (clk_i),
        .res_i             (res_i),
        .signed_number_i   (divisor_i),
        .start_i           (start_i),
        .ready_o           (ready_abs),
        .sign_o            (divisor_sign),
        .unsigned_number_o (divisor)
    );
    assign negate = dividend_sign!=divisor_sign ? 1 : 0;
    division_unsigned #(
        .g_latency(g_latency_division_unsigned),
        .g_dividend_width(g_dividend_width),
        .g_divisor_width(g_divisor_width)
        ) division_unsigned_inst (
        .clk_i      (clk_i),
        .dividend_i (dividend),
        .divisor_i  (divisor),
        .res_i      (res_i),
        .start_i    (ready_abs),
        .quotient_o (quotient),
        .ready_o    (ready_div_unsigned),
        .rem_o      (remainder_unsigned)
    );
    division_negate #(
        .g_latency(g_latency_fix_sign),
        .g_operand_width(g_dividend_width)
        ) division_negate_inst (
        .clk_i             (clk_i),
        .negate_i          (negate),
        .res_i             (res_i),
        .start_i           (ready_div_unsigned),
        .unsigned_number_i (quotient),
        .ready_o           (ready_o),
        .signed_number_o   (quotient_o)
    );
    division_negate #(
        .g_latency(g_latency_fix_sign),
        .g_operand_width(g_divisor_width)
        ) division_negate_rem_inst (
        .clk_i             (clk_i),
        .negate_i          (dividend_sign),
        .res_i             (res_i),
        .start_i           (ready_div_unsigned),
        .unsigned_number_i (remainder_unsigned),
        .ready_o           (),
        .signed_number_o   (remainder)
    );
    assign rem_o = remainder[g_divisor_width-1:0];
endmodule
