-- Filename: testbench_division_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Thu May  9 09:42:58 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of testbench_division is
    constant c_period : time := 10 ns;
    constant c_dividend_width            : natural := 6; -- 2; -- 8; --6;
    constant c_divisor_width             : natural := 4; -- 2; --6; --4;
    constant c_latency_division_unsigned : natural := 4; --12;
    constant c_latency_abs               : natural := 0; -- 1;
    constant c_latency_negate            : natural := 0; -- 1;

    signal clk            : std_logic := '0';
    signal dividend       : signed(c_dividend_width-1 downto 0);
    signal divisor        : signed(c_divisor_width-1 downto 0);
    signal quotient       : signed(c_dividend_width downto 0);
    signal ready          : std_logic;
    signal remainder      : signed(c_divisor_width-1 downto 0);
    signal remainder_mod  : signed(c_divisor_width-1 downto 0);
    signal remainder_rem  : signed(c_divisor_width-1 downto 0);
    signal res            : std_logic;
    signal run_simulation : boolean;
    signal start          : std_logic;
    component division is
        generic (
            constant g_latency_division_unsigned : natural := 1;
            constant g_latency_abs               : natural := 1;
            constant g_latency_negate            : natural := 1;
            constant g_dividend_width            : natural := 8;
            constant g_divisor_width             : natural := 4
        );
        port (
            clk_i      : in  std_logic;
            dividend_i : in  signed(g_dividend_width-1 downto 0);
            divisor_i  : in  signed(g_divisor_width-1 downto 0);
            res_i      : in  std_logic;
            start_i    : in  std_logic;
            quotient_o : out signed(g_dividend_width downto 0);
            ready_o    : out std_logic;
            rem_o      : out signed(g_divisor_width-1 downto 0)
        );
    end component;
begin
    division_inst : division
        generic map (
            g_dividend_width            => c_dividend_width,
            g_divisor_width             => c_divisor_width,
            g_latency_division_unsigned => c_latency_division_unsigned,
            g_latency_abs               => c_latency_abs,
            g_latency_negate            => c_latency_negate
        )
        port map (
            clk_i      => clk,
            dividend_i => dividend,
            divisor_i  => divisor,
            res_i      => res,
            start_i    => start,
            quotient_o => quotient,
            ready_o    => ready,
            rem_o      => remainder
        );
    process
    begin
        res <= '1', '0' after 1 ns;
        wait for c_period;
        while run_simulation loop
            clk <= not clk;
            wait for c_period/2;
        end loop;
        wait;
    end process;
    process
    begin
        run_simulation <= true;
        start <= '0';
        dividend <= (others => '0');
        divisor  <= (others => '0');
        wait for c_period;
        wait for 1 ns;
        for dividend_int in 2**(c_dividend_width-1)-1 downto -2**(c_dividend_width-1) loop
        --for dividend_int in 2**(c_dividend_width-1)-1 downto 2**(c_dividend_width-1)-1 loop
            for divisor_int in 2**(c_divisor_width-1)-1 downto -2**(c_divisor_width-1) loop
            --for divisor_int in 1 downto 1 loop
                if divisor_int/=0 then
                    dividend <= to_signed(dividend_int, c_dividend_width);
                    divisor  <= to_signed(divisor_int , c_divisor_width );
                    start <= '1', '0' after c_period;
                    wait until rising_edge(clk);
                    while ready/='1' loop
                        wait for c_period;
                    end loop;
                    remainder_mod <= dividend mod divisor;
                    remainder_rem <= dividend rem divisor;
                    assert quotient =resize(dividend, c_dividend_width+1)/divisor report "Wrong quotient"  severity error;
                    assert remainder=dividend rem divisor                         report "Wrong remainder" severity error;
                    wait for 1 ns;
                    wait for c_period;
                end if;
            end loop;
        end loop;
        run_simulation <= false;
        wait;
    end process;
    
end architecture;
