-- Filename: division_abs_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Thu May  9 09:42:58 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of division_abs is
begin
    combinatorial_g: if g_latency=0 generate
        ready_o <= start_i;
        sign_o  <= signed_number_i(g_operand_width-1);
        unsigned_number_o <= unsigned(signed_number_i) when signed_number_i(g_operand_width-1)='0' else
                             unsigned(-signed_number_i);
    end generate combinatorial_g;
    clocked_g: if g_latency/=0 generate
        process (res_i, clk_i)
        begin
            if res_i='1' then
                ready_o <= '0';
                sign_o  <= '0';
                unsigned_number_o <= (others => '0');
            elsif rising_edge(clk_i) then
                ready_o <= start_i;
                sign_o  <= signed_number_i(g_operand_width-1);
                if start_i='1' then
                    if signed_number_i(g_operand_width-1)='0' then
                        unsigned_number_o <= unsigned(signed_number_i);
                    else
                        unsigned_number_o <= unsigned(-signed_number_i);
                    end if;
                end if;
            end if;
        end process;
    end generate clocked_g;
end architecture;
