-- Filename: division_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Thu May  9 09:42:58 2024
architecture struct of division is
    signal dividend           : unsigned(g_dividend_width-1 downto 0);
    signal dividend_sign      : std_logic;
    signal divisor            : unsigned(g_divisor_width-1 downto 0);
    signal divisor_sign       : std_logic;
    signal negate             : std_logic;
    signal quotient           : unsigned(g_dividend_width-1 downto 0);
    signal ready_abs          : std_logic;
    signal ready_div_unsigned : std_logic;
    signal remainder          : signed(g_divisor_width downto 0);
    signal remainder_unsigned : unsigned(g_divisor_width-1 downto 0);
    component division_abs is
        generic (
            constant g_latency       : natural := 0;
            constant g_operand_width : natural := 8
        );
        port (
            clk_i             : in  std_logic;
            res_i             : in  std_logic;
            signed_number_i   : in  signed(g_operand_width-1 downto 0);
            start_i           : in  std_logic;
            ready_o           : out std_logic;
            sign_o            : out std_logic;
            unsigned_number_o : out unsigned(g_operand_width-1 downto 0)
        );
    end component;
    component division_unsigned is
        generic (
            constant g_latency        : natural := 8;
            constant g_dividend_width : natural := 8;
            constant g_divisor_width  : natural := 4
        );
        port (
            clk_i      : in  std_logic;
            dividend_i : in  unsigned(g_dividend_width-1 downto 0);
            divisor_i  : in  unsigned(g_divisor_width-1 downto 0);
            res_i      : in  std_logic;
            start_i    : in  std_logic;
            quotient_o : out unsigned(g_dividend_width-1 downto 0);
            ready_o    : out std_logic;
            rem_o      : out unsigned(g_divisor_width-1 downto 0)
        );
    end component;
    component division_negate is
        generic (
            constant g_latency       : natural := 0;
            constant g_operand_width : natural := 8
        );
        port (
            clk_i             : in  std_logic;
            negate_i          : in  std_logic;
            res_i             : in  std_logic;
            start_i           : in  std_logic;
            unsigned_number_i : in  unsigned(g_operand_width-1 downto 0);
            ready_o           : out std_logic;
            signed_number_o   : out signed(g_operand_width downto 0)
        );
    end component;
begin
    division_abs_dvd_inst : division_abs
        generic map (
            g_latency       => g_latency_abs,
            g_operand_width => g_dividend_width
        )
        port map (
            clk_i             => clk_i,
            res_i             => res_i,
            signed_number_i   => dividend_i,
            start_i           => start_i,
            ready_o           => open,
            sign_o            => dividend_sign,
            unsigned_number_o => dividend
        );
    division_abs_dvr_inst : division_abs
        generic map (
            g_latency       => g_latency_abs,
            g_operand_width => g_divisor_width
        )
        port map (
            clk_i             => clk_i,
            res_i             => res_i,
            signed_number_i   => divisor_i,
            start_i           => start_i,
            ready_o           => ready_abs,
            sign_o            => divisor_sign,
            unsigned_number_o => divisor
        );
    negate <= '1' when dividend_sign/=divisor_sign else
              '0';
    division_unsigned_inst : division_unsigned
        generic map (
            g_latency        => g_latency_division_unsigned,
            g_dividend_width => g_dividend_width,
            g_divisor_width  => g_divisor_width
        )
        port map (
            clk_i      => clk_i,
            dividend_i => dividend,
            divisor_i  => divisor,
            res_i      => res_i,
            start_i    => ready_abs,
            quotient_o => quotient,
            ready_o    => ready_div_unsigned,
            rem_o      => remainder_unsigned
        );
    division_negate_inst : division_negate
        generic map (
            g_latency       => g_latency_negate,
            g_operand_width => g_dividend_width
        )
        port map (
            clk_i             => clk_i,
            negate_i          => negate,
            res_i             => res_i,
            start_i           => ready_div_unsigned,
            unsigned_number_i => quotient,
            ready_o           => ready_o,
            signed_number_o   => quotient_o
        );
    division_negate_rem_inst : division_negate
        generic map (
            g_latency       => g_latency_negate,
            g_operand_width => g_divisor_width
        )
        port map (
            clk_i             => clk_i,
            negate_i          => dividend_sign,
            res_i             => res_i,
            start_i           => ready_div_unsigned,
            unsigned_number_i => remainder_unsigned,
            ready_o           => open,
            signed_number_o   => remainder
        );
    rem_o <= remainder(g_divisor_width-1 downto 0);
end architecture;
