-- Filename: division_negate_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Thu May  9 09:42:59 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of division_negate is
begin
    combinatorial_g: if g_latency=0 generate
        ready_o <= start_i;
        signed_number_o <=  signed(resize(unsigned_number_i, g_operand_width+1)) when negate_i='0' else
                           -signed(resize(unsigned_number_i, g_operand_width+1));
    end generate combinatorial_g;
    clocked_g: if g_latency/=0 generate
        process (res_i, clk_i)
        begin
            if res_i='1' then
                ready_o <= '0';
                signed_number_o <= (others => '0');
            elsif rising_edge(clk_i) then
                ready_o <= start_i;
                if start_i='1' then
                    if negate_i='0' then
                        signed_number_o <=  signed(resize(unsigned_number_i, g_operand_width+1));
                    else
                        signed_number_o <= -signed(resize(unsigned_number_i, g_operand_width+1));
                    end if;
                end if;
            end if;
        end process;
    end generate clocked_g;
end architecture;
