-- Filename: division_div_operator.vhd.vhd
-- Created by HDL-SCHEM-Editor at Mon May  6 18:11:25 2024
architecture div_operator of division is
begin
    process(res_i, clk_i)
    begin
        if res_i='1' then
            quotient_o <= (others => '0');
            rem_o      <= (others => '0');
            ready_o    <= '0';
        elsif rising_edge(clk_i) then
            if start_i='1' then
                assert divisor_i/=(divisor_i'range => '0') report "Division by 0 is not allowed" severity error;
                quotient_o <= resize(dividend_i, g_dividend_width+1)/divisor_i;
                rem_o      <= dividend_i rem divisor_i;
            end if;
            ready_o    <= start_i;
        end if;
    end process;
end architecture;
