-- Filename: division_unsigned_step_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Wed Jun 19 10:42:55 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of division_unsigned_step is
    signal divisor            : unsigned(g_divisor_width downto 0);
    signal interim_result     : unsigned(g_divisor_width downto 0);
    signal new_interim_result : unsigned(g_divisor_width downto 0);
begin
    interim_result <= interim_result_i & dividend_bit_i;
    divisor        <= '0' & divisor_i;
    p_calc: process (quotient_bit_last_i, interim_result, divisor)
    begin
        -- "Non Restoring" division algorithm:
        if quotient_bit_last_i='1' then
            new_interim_result <= interim_result - divisor;
        else
            new_interim_result <= interim_result + divisor;
        end if;
    end process;
    quotient_bit_o   <= not new_interim_result(g_divisor_width);
    interim_result_o <=     new_interim_result(g_divisor_width-1 downto 0);
end architecture;
