-- Filename: testbench_cordic_square_root_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Mon Jan 27 18:13:19 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.math_real.all;
architecture struct of testbench_cordic_square_root is
    constant c_period                   : time    := 10 ns;
    constant c_radicand_width           : natural := 4;
    constant c_improved_accuracy        : boolean := false;
    constant c_latency_prepare          : natural :=  1; -- allowed values    : 0..1 (values >1 are set to 1)
    constant c_latency_shift_radicand   : natural :=  1; -- allowed values    : 0..1 (values >1 are set to 1)
    constant c_latency_rotate_by_cordic : natural :=  1;--(c_radicand_width + c_radicand_width mod 2)/2; -- Recommended values: 0..(c_radicand_width + c_radicand_width mod 2)/2
    constant c_latency_shift_back       : natural :=  1; -- allowed values    : 0..1 (values >1 are set to 1)
    signal clk               : std_logic := '0';
    signal radicand          : unsigned(c_radicand_width-1 downto 0) := (others => '0');
    signal ready             : std_logic;
    signal res               : std_logic;
    signal run_simulation    : std_logic := '1';
    signal square_root_fract : unsigned(c_radicand_width/2-1+c_radicand_width mod 2 downto 0);
    signal square_root_int   : unsigned(c_radicand_width/2+c_radicand_width mod 2 downto 0);
    signal start             : std_logic;
    component cordic_square_root is
        generic (
            constant g_radicand_width           : natural := 27;    -- allowed values    : 1..1328
            constant g_improved_accuracy        : boolean := false; -- allowed values    : true/false
            constant g_latency_prepare          : natural :=  1;    -- allowed values    : 0..1 (values >1 are set to 1)
            constant g_latency_shift_radicand   : natural :=  1;    -- allowed values    : 0..1 (values >1 are set to 1)
            constant g_latency_rotate_by_cordic : natural :=  1;    -- recommended values: 0..(g_radicand_width + g_radicand_width mod 2)/2, allowed all
            constant g_latency_shift_back       : natural :=  1     -- allowed values    : 0..1 (values >1 are set to 1)
        );
        port (
            clk_i               : in  std_logic;
            radicand_i          : in  unsigned(g_radicand_width-1 downto 0);
            res_i               : in  std_logic;
            start_i             : in  std_logic;
            ready_o             : out std_logic;
            square_root_fract_o : out unsigned(g_radicand_width/2-1+g_radicand_width mod 2 downto 0);
            square_root_o       : out unsigned(g_radicand_width/2+g_radicand_width mod 2 downto 0)
        );
    end component;
begin
    res <= '1', '0' after 1 ns;
    process
    begin
        while run_simulation='1' loop
            clk <= not clk;
            wait for c_period/2;
        end loop;
        wait;
    end process;
    cordic_square_root_inst : cordic_square_root
        generic map (
            g_radicand_width           => c_radicand_width,           -- Allowed values    : 1..1328
            g_improved_accuracy        => c_improved_accuracy,        -- Allowed values    : true/false
            g_latency_shift_radicand   => c_latency_shift_radicand,   -- allowed values    : 0..1 (values >1 are set to 1)
            g_latency_prepare          => c_latency_prepare,          -- allowed values    : 0..1 (values >1 are set to 1)
            g_latency_rotate_by_cordic => c_latency_rotate_by_cordic, -- Recommended values: 0..(g_radicand_width + g_radicand_width mod 2)/2, allowed all
            g_latency_shift_back       => c_latency_shift_back        -- allowed values    : 0..1 (values >1 are set to 1)
        )
        port map (
            clk_i               => clk,
            radicand_i          => radicand,
            res_i               => res,
            start_i             => start,
            ready_o             => ready,
            square_root_fract_o => square_root_fract,
            square_root_o       => square_root_int
        );
    process
        variable square_root_all : unsigned(c_radicand_width/2 + c_radicand_width/2 + 2*(c_radicand_width mod 2) downto 0);
        variable square_root_all_real : real;
        variable delta : real;
        variable delta_max : real;
        variable delta_per_cent : real;
        variable delta_max_per_cent : real;
    begin
        run_simulation <= '1';
        radicand        <= (others => '0');
        start          <= '0';
        delta_max := 0.0;
        wait for 1.1 * c_period;
        for i in 0 to 2**c_radicand_width-1 loop
            start <= '1', '0' after c_period;
            radicand <= to_unsigned(i, c_radicand_width);
            wait until ready='1';
            wait for c_period/10;
            square_root_all := square_root_int & square_root_fract;
            square_root_all_real := 0.0;
            for b in 0 to c_radicand_width + 2*c_radicand_width mod 2 loop
                if square_root_all(b)='1' then
                    square_root_all_real := square_root_all_real + 2.0**(b-square_root_fract'length);
                end if;
            end loop;
            delta := abs(square_root_all_real-sqrt(real(i)));
            if delta>delta_max then
                delta_max := delta;
            end if;
            delta_per_cent := delta/sqrt(real(i))*100.0;
            if delta_per_cent>delta_max_per_cent then
                delta_max_per_cent := delta_per_cent;
            end if;
            -- assert delta<0.09 report "Fehler bei radicand = " & integer'image(i) & ": " & LF &
                                                             -- "square_root = " & real'image(square_root_all_real) & LF &
                                                             -- "reference   = " & real'image(sqrt(real(i))) & LF &
                                                             -- "delta       = " & real'image(square_root_all_real-sqrt(real(i))) severity warning;
            -- assert delta_per_cent<2.0 report "Fehler bei radicand = " & integer'image(i) & ": " & LF &
                                                             -- "square_root    = " & real'image(square_root_all_real) & LF &
                                                             -- "reference      = " & real'image(sqrt(real(i))) & LF &
                                                             -- "delta_per_cent = " & real'image(delta_per_cent) severity warning;
            wait for c_period;
        end loop;
        report "delta_max = " & real'image(delta_max);
        report "delta_max_per_cent = " & real'image(delta_max_per_cent);
        run_simulation <= '0';
        wait;
    end process;
end architecture;
