-- Filename: cordic_square_root_shift_radicand_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Mon Jan 27 18:13:19 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of cordic_square_root_shift_radicand is
    function determine_number_of_leading_double_zeros (signal radicand_in : in unsigned) return natural is
        variable double_zero_counter : natural;
    begin
        double_zero_counter := 0;
        for i in 0 to radicand_in'length/2-2 loop -- The 2 least significant bits are not checked.
            if radicand_in(radicand_in'high-2*i downto radicand_in'high-2*i-1)="00" then
                double_zero_counter := double_zero_counter + 1;
            else
                exit;
            end if;
        end loop;
        return double_zero_counter;
    end function;
    signal radicand         : unsigned(g_radicand_width_even - 1 downto 0);
    signal radicand_shifted : unsigned(g_radicand_width_even - 1 downto 0);
    signal shift_nr         : natural range 0 to g_radicand_width_even/2-1;
begin
    -- Create an even number of bits:
    process(radicand_i)
    begin
        radicand <= (others => '0');
        radicand(radicand_i'range) <= radicand_i;
    end process;
    -- Determine how often the radicand can be shifted:
    shift_nr <= determine_number_of_leading_double_zeros(radicand);
    radicand_shifted <= shift_left(radicand, shift_nr*2);
    shift_comb_g: if g_latency_shift_radicand=0 generate
        radicand_zero_o    <= '1' when radicand_i=0 else '0';
        radicand_shifted_o <= radicand_shifted;
        shift_nr_o         <= shift_nr;
        ready_o            <= start_i;
    end generate shift_comb_g;
    shift_reg_g: if g_latency_shift_radicand/=0 generate
        process(res_i, clk_i)
        begin
            if res_i='1' then
                radicand_zero_o    <= '0';
                radicand_shifted_o <= (others => '0');
                shift_nr_o         <=  0;
                ready_o            <= '0';
            elsif rising_edge(clk_i) then
                ready_o <= '0';
                if start_i='1' then
                    if radicand_i=0 then
                        radicand_zero_o <= '1';
                    else
                        radicand_zero_o <= '0';
                    end if;
                    radicand_shifted_o <= radicand_shifted;
                    shift_nr_o         <= shift_nr;
                    ready_o            <= start_i;
                end if;
            end if;
        end process;
    end generate shift_reg_g;
end architecture;
