-- Filename: cordic_square_root_shift_back_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Sun Jan 12 11:59:13 2025
architecture struct of cordic_square_root_shift_back is
    signal square_root_cordic         : unsigned(g_radicand_width_even downto 0);
    signal square_root_cordic_shifted : unsigned(g_radicand_width_even downto 0);
begin
    -- Remove additional bits (if they exist):
    square_root_cordic <= square_root_cordic_i(g_radicand_width_ext downto
                                               g_radicand_width_ext-g_radicand_width_even);
    -- Back to original size:
    square_root_cordic_shifted <= shift_right(square_root_cordic, shift_nr_i) when radicand_zero_i='0' else
                                  (others => '0');
    shift_comb_g: if g_latency_shift_back=0 generate
        ready_o             <= start_i;
        -- Pick the integer part:
        square_root_o       <= square_root_cordic_shifted(g_radicand_width_even downto g_radicand_width_even/2);
        -- Pick the fractional part:
        square_root_fract_o <= square_root_cordic_shifted(g_radicand_width_even/2-1 downto 0);
    end generate shift_comb_g;
    shift_reg_g: if g_latency_shift_back/=0 generate
        p1: process(res_i, clk_i)
        begin
            if res_i='1' then
                ready_o             <= '0';
                square_root_o       <= (others => '0');
                square_root_fract_o <= (others => '0');
            elsif rising_edge(clk_i) then
                ready_o <= start_i;
                if start_i='1' then
                    -- Pick the integer part:
                    square_root_o       <= square_root_cordic_shifted(g_radicand_width_even downto g_radicand_width_even/2);
                    -- Pick the fractional part:
                    square_root_fract_o <= square_root_cordic_shifted(g_radicand_width_even/2-1 downto 0);
                end if;
            end if;
        end process;
    end generate shift_reg_g;
end architecture;
