-- Filename: cordic_square_root_shift_radicand_e.vhd
-- Created by HDL-SCHEM-Editor at Mon Jan 27 18:13:19 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity cordic_square_root_shift_radicand is
    generic (
        constant g_radicand_width         : natural := 16;
        constant g_radicand_width_even    : natural := 16;
        constant g_latency_shift_radicand : natural :=  0 
    );
    port (
        clk_i              : in  std_logic;
        radicand_i         : in  unsigned(g_radicand_width-1 downto 0);
        res_i              : in  std_logic;
        start_i            : in  std_logic;
        radicand_shifted_o : out unsigned(g_radicand_width_even - 1 downto 0);
        radicand_zero_o    : out std_logic;
        ready_o            : out std_logic;
        shift_nr_o         : out natural range 0 to g_radicand_width_even/2-1
    );
end entity cordic_square_root_shift_radicand;
