-- Filename: cordic_square_root_rotate_step_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Sun Jan 12 11:59:13 2025
architecture struct of cordic_square_root_rotate_step is
    signal delta_x     : signed(g_radicand_width_ext+1 downto 0);
    signal delta_x_tmp : signed(g_radicand_width_ext+1 downto 0);
    signal delta_y     : signed(g_radicand_width_ext+1 downto 0);
begin
    -- A right shift of a small positive number is able to create 0.
    -- But a right shift of -1 will always create -1.
    -- This is fixed here and needed, when additional iterations are executed,
    -- which are inserted to fill the gap to the given latency:
    delta_x_tmp <= shift_right(y_coord_i, step_i);
    delta_x <= delta_x_tmp when delta_x_tmp/=(delta_x_tmp'range => '1') else (others => '0');
    delta_y <= shift_right(x_coord_i, step_i); -- Always positive
    process(x_coord_i, delta_x, y_coord_i, delta_y)
    begin
    -- Hyperbolic cordic algorithm:
    if y_coord_i(y_coord_i'high)='1' then
            -- y_coord_i<0, delta_x<0, delta_y>0:
            x_coord_o <= x_coord_i + delta_x; -- decrease
            y_coord_o <= y_coord_i + delta_y; -- increase
        else
            -- y_coord_i>0, delta_x>0, delta_y>0:
            x_coord_o <= x_coord_i - delta_x; -- decrease
            y_coord_o <= y_coord_i - delta_y; -- decrease
        end if;
    end process;
end architecture;
