-- Filename: cordic_square_root_prepare_operands_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Sun Jan 19 11:53:41 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.math_real.all;
architecture struct of cordic_square_root_prepare_operands is
    -- The real value of c_mod_value_unsigned is : 0.3645122921641043011602168...
    -- The constant c_mod_value_unsigned was derived after 700 iterations.
    -- It does not matter, when it is used by a configuration with less iterations, as the used MSBs are always correct.
    constant c_mod_value_unsigned : unsigned (1327 downto 0) := X"5D50AD75D5B717FEBCE9B6781353ED5F6D6A7350F7DDD1481D7141AD3F76081DBE22A94C9135ED5A2DEBD681F3D7E782D60F34CAFBEC95A274082193AE285FEA9C967CEC10F7A1AC975286B66FA230CE8157F6B59D5A20581BD4F1D76207EDA2F04848F84EB63104BCC7E65E220338482156255343E955F9EFDBBA1A9BD69D0718225AB547A256ABB6DBEEE164F72F0AFBC95D5BA554A307B1A76690A04B5253E2B6B1AE6714";
    -- Add a signbit and an overflow bit:
    constant c_mod_value : signed (g_radicand_width_ext+1 downto 0) := "00" & signed(c_mod_value_unsigned(c_mod_value_unsigned'high downto c_mod_value_unsigned'high-g_radicand_width_ext+1));
    signal radicand_m           : signed(g_radicand_width_ext+1 downto 0);
    signal radicand_p           : signed(g_radicand_width_ext+1 downto 0);
    signal radicand_shifted_ext : unsigned(g_radicand_width_ext-1 downto 0);
    -- Python program for calculating c_mod_value_unsigned:
    -- import math
    -- import mpmath as mp_math
    -- mp_math.mp.dps = 400 # Number of digits of floating point number
    -- biggest_integer = 10**mp_math.mp.dps - 1
    -- number_of_bits_for_biggest_integer = mp_math.ceil(mp_math.log(biggest_integer, 2))
    -- if number_of_bits_for_biggest_integer%4!=0:
         -- # Prepare for presentation as hex-number:
        -- number_of_bits_for_biggest_integer -= number_of_bits_for_biggest_integer%4
    -- print("number_of_bits_for_biggest_integer =", number_of_bits_for_biggest_integer)
    -- length_correction = 1
    -- for i in range(1,700):
        -- k = 0
        -- while True:
            -- if 3**(k+1)+2*k-1<=2*i:
                -- k += 1
            -- else:
                -- k_result = k - 1
                -- break
        -- length_correction = mp_math.fmul(length_correction, mp_math.sqrt(mp_math.fsub(1, mp_math.power(2,-2*(i-k_result)))))
    -- print("length_correction =", length_correction)
    -- c_mod_value = mp_math.fdiv(1, mp_math.fmul(4, mp_math.fmul(length_correction, length_correction)))
    -- print("c_mod_value =", c_mod_value)
    -- c_mod_value_bin = mp_math.fmul(c_mod_value, mp_math.power(2,number_of_bits_for_biggest_integer))
    -- FORMAT_STRING = "{:0" + str(int(number_of_bits_for_biggest_integer/4)) + "X}" # Because 4 bits are coded into 1 hex-number, there is a division by 4.
    -- print("{:4}".format(i) + ' => x"' + FORMAT_STRING.format(int(c_mod_value_bin)) + '",')
begin
    -- For both operands: Convert to signed and add an overflow bit.
    -- The overflow bit is only needed for radicand_p.
    -- The signbit is only needed for radicand_m.
    -- For better readability both operands are handled in the same way.
    -- The hyperbolic cordic agorithm interpretes radicand_shift_i in this way:
    -- 0.25 <= radicand_shifted_i < 1.0
    radicand_p <= "00" & signed(radicand_shifted_ext) + c_mod_value;
    radicand_m <= "00" & signed(radicand_shifted_ext) - c_mod_value;
    comb_g: if g_latency_prepare=0 generate
        radicand_p_o <= radicand_p;
        radicand_m_o <= radicand_m;
        ready_o      <= start_i;
    end generate comb_g;
    reg_g: if g_latency_prepare/=0 generate
        process(res_i, clk_i)
        begin
            if res_i='1' then
                radicand_p_o <= (others => '0');
                radicand_m_o <= (others => '0');
                ready_o      <= '0';
            elsif rising_edge(clk_i) then
                ready_o <= start_i;
                if start_i='1' then
                    radicand_p_o <= radicand_p;
                    radicand_m_o <= radicand_m;
                end if;
            end if;
        end process;
    end generate reg_g;
    process(radicand_shifted_i)
    begin
        radicand_shifted_ext <= (others => '0');
        radicand_shifted_ext(radicand_shifted_ext'high downto
                             radicand_shifted_ext'high-g_radicand_width_even+1) <= radicand_shifted_i;
    end process;
end architecture;
