-- Filename: cordic_square_root_shift_back_e.vhd
-- Created by HDL-SCHEM-Editor at Sun Jan 12 11:59:13 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity cordic_square_root_shift_back is
    generic (
        constant g_radicand_width_even : natural := 32;
        constant g_radicand_width_ext  : natural := 32;
        constant g_latency_shift_back  : natural :=  0 
    );
    port (
        clk_i                : in  std_logic;
        radicand_zero_i      : in  std_logic;
        res_i                : in  std_logic;
        shift_nr_i           : in  natural range 0 to g_radicand_width_ext/2-1;
        square_root_cordic_i : in  unsigned(g_radicand_width_ext downto 0);
        start_i              : in  std_logic;
        ready_o              : out std_logic;
        square_root_fract_o  : out unsigned(g_radicand_width_even/2-1 downto 0);
        square_root_o        : out unsigned(g_radicand_width_even/2 downto 0)
    );
end entity cordic_square_root_shift_back;
