-- Filename: testbench_clock_divider_struct.vhd
-- Created by HDL-SCHEM-Editor at Mon Jun  2 17:16:36 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of testbench_clock_divider is
    constant c_clock_period        : time    := 10 ns;
    constant c_period_width        : natural := 8;
    constant c_fraction_width      : natural := 4;
    constant c_create_clock_enable : boolean := false;
    signal clk                                 : std_logic := '0';
    signal clk_divided                         : std_logic;
    signal clock_period_fract_part_denominator : unsigned (c_fraction_width-1 downto 0);
    signal clock_period_fract_part_nominator   : unsigned (c_fraction_width-1 downto 0);
    signal clock_period_int_part               : unsigned (c_period_width-1 downto 0);
    signal edge_counter                        : integer;
    signal enable_clock_divider                : std_logic;
    signal jitter                              : time;
    signal point_in_time_of_first_edge         : time;
    signal res                                 : std_logic;
    signal run_simulation                      : std_logic := '1';
    component clock_divider is
        generic (
            constant g_period_width        : natural := 8; -- allowed values: >= 2
            constant g_fraction_width      : natural := 3; -- allowed values: >= 2
            constant g_create_clock_enable : boolean := true 
        );
        port (
            clk_i                                 : in  std_logic ;
            clock_period_fract_part_denominator_i : in  unsigned (g_fraction_width-1 downto 0);
            clock_period_fract_part_nominator_i   : in  unsigned (g_fraction_width-1 downto 0);
            clock_period_int_part_i               : in  unsigned (g_period_width-1 downto 0);
            enable_clock_divider_i                : in  std_logic ;
            res_i                                 : in  std_logic ;
            clk_divided_o                         : out std_logic 
        );
    end component;
begin
    res <= '1', '0' after 1 ns;
    process
    begin
        while run_simulation='1' loop
            clk <= not clk;
            wait for c_clock_period/2;
        end loop;
        wait;
    end process;
    clock_divider_inst : clock_divider
        generic map (
            g_period_width        => c_period_width,   -- allowed values: >= 2
            g_fraction_width      => c_fraction_width, -- allowed values: >= 2
            g_create_clock_enable => c_create_clock_enable
        )
        port map (
            clk_i                                 => clk,
            clock_period_fract_part_denominator_i => clock_period_fract_part_denominator,
            clock_period_fract_part_nominator_i   => clock_period_fract_part_nominator,
            clock_period_int_part_i               => clock_period_int_part,
            enable_clock_divider_i                => enable_clock_divider,
            res_i                                 => res,
            clk_divided_o                         => clk_divided
        );
    process
    begin
        enable_clock_divider <= '0';
        clock_period_int_part               <= to_unsigned(8, c_period_width);
        clock_period_fract_part_nominator   <= to_unsigned(1, c_fraction_width);
        clock_period_fract_part_denominator <= to_unsigned(3, c_fraction_width);
        wait for c_clock_period * 10.5;
        enable_clock_divider <= '1';
        while now<1 us loop
            wait for c_clock_period;
        end loop;
    
        enable_clock_divider <= '0';
        clock_period_int_part               <= to_unsigned(8, c_period_width);
        clock_period_fract_part_nominator   <= to_unsigned(3, c_fraction_width);
        clock_period_fract_part_denominator <= to_unsigned(9, c_fraction_width);
        wait for c_clock_period * 10.5;
        enable_clock_divider <= '1';
        while now<3 us loop
            wait for c_clock_period;
        end loop;
        run_simulation <= '0';
        wait;
    end process;
    process
    begin
        edge_counter <= 0;
        jitter       <= 0 ns;
        point_in_time_of_first_edge <= 0 ns;
        while true loop
            wait until enable_clock_divider='1';
            wait until rising_edge(clk_divided);
            edge_counter <= edge_counter + 1;
            point_in_time_of_first_edge <= now;
            while enable_clock_divider='1' loop
                wait until rising_edge(clk_divided) or enable_clock_divider='0';
                if enable_clock_divider='1' then
                    jitter <= now - point_in_time_of_first_edge -
                              edge_counter * (to_integer(clock_period_int_part)*c_clock_period + real(to_integer(clock_period_fract_part_nominator))/real(to_integer(clock_period_fract_part_denominator))*c_clock_period);
                    if edge_counter=to_integer(clock_period_fract_part_denominator) then
                        edge_counter <= 1;
                        point_in_time_of_first_edge <= now;
                    else
                        edge_counter <= edge_counter + 1;
                    end if;
                end if;
            end loop;
            edge_counter <= 0;
        end loop;
    end process;
end architecture;
