-- Filename: clock_divider_e.vhd
-- Created by HDL-SCHEM-Editor at Mon Jun  2 17:11:38 2025
--
-- clock_divider documentation
-- ===========================
-- (see also http://www.hdl-schem-editor.de/clock_divider/clock_divider.php)
-- The clock_divider module shall create a clock whose period is n-times longer than that of the incoming clock.
-- The factor n is defined as (with '/' being a division with a real number result):
-- n = clock_period_int_part_i + clock_period_fract_part_nominator_i/clock_period_fract_part_denominator_i
-- However, since the clock_divider module will create the new clock using only a simple counter,
-- the desired period must be approximated by creating a new clock whose period alternates
-- between clock_period_int_part_i and clock_period_int_part_i+1 times the incoming period.
-- In this way after clock_period_fract_part_denominator_i periods of the new clock, the new clock will always have a rising clock edge
-- that occurs at an exact correct point in time, as multiplying n with clock_period_fract_part_denominator_i creates an integer number:
-- clock_period_fract_part_denominator_i*n = clock_period_fract_part_denominator_i*clock_period_int_part_i + clock_period_fract_part_nominator_i
-- The timing of all other rising clock edges will not be exact, but will behave as if the new clock had a jitter.
-- This jitter is kept as small as possible.
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity clock_divider is
    generic (
        constant g_period_width        : natural := 8; -- Allowed values: >= 2
        constant g_fraction_width      : natural := 3; -- Allowed values: >= 2
        constant g_create_clock_enable : boolean := true
    );
    port (
        clk_i                                 : in  std_logic;
        clock_period_fract_part_denominator_i : in  unsigned(g_fraction_width-1 downto 0);
        clock_period_fract_part_nominator_i   : in  unsigned(g_fraction_width-1 downto 0);
        clock_period_int_part_i               : in  unsigned(g_period_width-1 downto 0); -- Allowed values: >= 2
        enable_clock_divider_i                : in  std_logic;
        res_i                                 : in  std_logic;
        clk_divided_o                         : out std_logic
    );
end entity clock_divider;
