-- Filename: ahb_slave_e.vhd
-- Created by HDL-FSM-Editor at Fri Nov 21 15:03:11 2025
library ieee;
use ieee.std_logic_1164.all;
use work.ahb_package.all;

entity ahb_slave is
    generic (
        g_slave_number      : natural  :=  1;
        g_addr_width        : positive := 16; -- Maximum is 16 (because the address is copied into hrdata_o(15:0)
        g_start_address     : std_logic_vector(g_addr_width-1 downto 0);
        g_wait1_address     : std_logic_vector(g_addr_width-1 downto 0);
        g_wait2_address     : std_logic_vector(g_addr_width-1 downto 0);
        g_slave_addr_width  : positive :=  8;
        g_hburst_width      : natural  :=  3;
        g_hprot_width       : natural  :=  4;
        g_data_width        : positive := 32  -- Minimum is 32 (because the slave number is copied into hrdata_o(31:16)
    );
    port (
        hresetn_i   : in std_logic;
        hclk_i      : in std_logic;
        hready_i    : in std_logic;
        hsel_i      : in std_logic;
        hcontrol_i  : in t_ahb_control(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
        hwdata_i    : in std_logic_vector(g_data_width-1 downto 0);
        hreadyout_o : out std_logic;
        hresp_o     : out std_logic;
        hrdata_o    : out std_logic_vector(g_data_width-1 downto 0) 
    );
end entity;
