-- Filename: ahb_master_e.vhd
-- Created by HDL-SCHEM-Editor at Thu Dec  4 14:36:38 2025
library ieee;
use ieee.std_logic_1164.all;
use work.ahb_package.all;
entity ahb_master is
    generic (
        g_period              : time := 10 ns;
        g_master_number       : natural  := 0;
        g_addr_width          : positive := 16;
        g_data_width          : positive := 32;
        g_hburst_width        : natural  :=  3;
        g_hprot_width         : natural  :=  4;
        g_number_of_slaves    : positive := 2;
        g_slave_address_width : t_positive_list(0 to g_number_of_slaves-1) := (12, 8);
        g_start_addresses     : t_std_logic_vector_list(0 to g_number_of_slaves-1)(g_addr_width-1 downto 0) := (X"1000", X"3400") 
    );
    port (
        hready_i           : in  std_logic;
        master_hrdata_i    : in  std_logic_vector(g_data_width-1 downto 0);
        master_hresp_i     : in  std_logic;
        hcontrol_o         : out t_ahb_control(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
        hwdata_o           : out std_logic_vector(g_data_width-1 downto 0);
        stimulation_runs_o : out std_logic
    );
end entity ahb_master;
