-- Filename: ahb_slave_fsm.vhd
-- Created by HDL-FSM-Editor at Wed Oct 15 18:45:15 2025
library ieee;
use ieee.numeric_std.all;

architecture fsm of ahb_slave is
    type t_state is (wait1, active, wait2);
    signal state : t_state;
    signal hcontrol_s        : t_ahb_control(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
    signal check_write_data  : std_logic;
    
    signal slave_haddr     : std_logic_vector(g_addr_width-1 downto 0);
    signal slave_hburst    : std_logic_vector(g_hburst_width-1 downto 0);
    signal slave_hsize     : std_logic_vector(2 downto 0);
    signal slave_hprot     : std_logic_vector(g_hprot_width-1 downto 0);
    signal slave_htrans    : std_logic_vector(1 downto 0);
    signal slave_hwrite    : std_logic;signal slave_hmastlock : std_logic;
    signal create_err_resp : std_logic;
    
begin
    p_states: process (hresetn_i, hclk_i)
    begin
        if hresetn_i='0' then
            state <= active;
            hrdata_o <= (others => '0');
            check_write_data <= '0';
        elsif rising_edge(hclk_i) then
            -- State Machine:
            case state is
                when wait1 =>
                    state <= wait2;
                when active =>
                    if check_write_data='1' then
                        report " Slave " & integer'image(g_slave_number) & ": Check access from master " & integer'image(to_integer(unsigned(hwdata_i(31 downto 28))));
                        assert hcontrol_s.haddr(g_addr_width-1 downto g_slave_addr_width)=
                               g_start_address (g_addr_width-1 downto g_slave_addr_width) report "Error in slave " & integer'image(g_slave_number) &
                                                                " : haddr "  & to_hstring(hcontrol_s.haddr) &
                                                                " is not in the range from start-address " & to_hstring(g_start_address) &
                                                                " to end-address " & to_hstring(to_unsigned(to_integer(unsigned(g_start_address)) + 2**g_slave_addr_width - 1, g_addr_width)) severity warning;
                        assert hcontrol_s.haddr =hwdata_i(   g_addr_width-1 downto  0) report "Error in slave " & integer'image(g_slave_number) &
                                                                " : haddr is wrong:"  & to_hstring(hcontrol_s.haddr)  & ' ' & to_hstring(hwdata_i(g_addr_width-1 downto  0)) severity warning;
                        assert hcontrol_s.hsize =hwdata_i(               18 downto 16) report "Error in slave " & integer'image(g_slave_number) &
                                                                " : hsize is wrong:"  & to_hstring(hcontrol_s.hsize)  & ' ' & to_hstring(hwdata_i(            18 downto 16)) severity warning;
                        assert hcontrol_s.hburst=hwdata_i(19+g_hburst_width downto 20) report "Error in slave " & integer'image(g_slave_number) &
                                                                " : hburst is wrong:" & to_hstring(hcontrol_s.hburst) & ' ' & to_hstring(hwdata_i(            22 downto 20)) severity warning;
                        assert hcontrol_s.htrans=hwdata_i(               25 downto 24) report "Error in slave " & integer'image(g_slave_number) &
                                                                " : htrans is wrong:" & to_hstring(hcontrol_s.htrans) & ' ' & to_hstring(hwdata_i(            25 downto 24)) severity warning;
                    end if;
                    if hready_i='1' and hsel_i='1' and hcontrol_i.htrans/="00" then
                        hrdata_o <= (others => '0');
                        hcontrol_s <= hcontrol_i;
                        check_write_data <= '0';
                        create_err_resp <= '0';
                        if hcontrol_i.haddr(g_addr_width-1 downto 4)=g_wait2_address(g_addr_width-1 downto 4) or
                           hcontrol_i.haddr=x"123F"
                        then
                            if hcontrol_i.haddr=x"123F" then
                                create_err_resp <= '1';
                            else
                                create_err_resp <= '0';
                            end if;
                            
                            
                            state <= wait1;
                        elsif hcontrol_i.haddr(g_addr_width-1 downto 4)=g_wait1_address(g_addr_width-1 downto 4) then
                            state <= wait2;
                        else
                            check_write_data <= '1'; -- Even at reads, write-data carries verification-information
                            hrdata_o <= (others => '0');
                            hrdata_o   (g_addr_width-1 downto  0) <= hcontrol_i.haddr;
                            hrdata_o               (18 downto 16) <= hcontrol_i.hsize;
                            hrdata_o(19+g_hburst_width downto 20) <= hcontrol_i.hburst;
                            hrdata_o               (25 downto 24) <= hcontrol_i.htrans;
                            hrdata_o               (31 downto 28) <= std_logic_vector(to_unsigned(g_slave_number, 4));
                        end if;
                    else
                        hrdata_o <= (others => '0');
                        check_write_data <= '0';
                        create_err_resp <= '0';
                    end if;
                when wait2 =>
                    check_write_data <= '1'; -- Even at reads, write-data carries verification-information
                    hrdata_o <= (others => '0');
                    hrdata_o   (g_addr_width-1 downto  0) <= hcontrol_s.haddr;
                    hrdata_o               (18 downto 16) <= hcontrol_s.hsize;
                    hrdata_o(19+g_hburst_width downto 20) <= hcontrol_s.hburst;
                    hrdata_o               (25 downto 24) <= hcontrol_s.htrans;
                    hrdata_o               (31 downto 28) <= std_logic_vector(to_unsigned(g_slave_number, 4));
                    state <= active;
            end case;
        end if;
    end process;
    p_state_actions: process (create_err_resp, state)
    begin
        -- State Actions:
        case state is
            when wait1=>
                hreadyout_o <= '0';
            when active=>
                hreadyout_o <= '1';
                if create_err_resp then
                    hresp_o <= '1';
                else
                    hresp_o <= '0';
                end if;
            when wait2=>
                hreadyout_o <= '0';
                if create_err_resp='1' then
                    hresp_o <= '1';
                else
                    hresp_o <= '0';
                end if;
        end case;
    end process;
    -- Global Actions combinatorial:
    debug_record(hcontrol_i,
    slave_haddr,
    slave_hsize,
    slave_hburst,
    slave_hprot,
    slave_htrans,
    slave_hwrite,
    slave_hmastlock
    );
end architecture;
