-- Filename: testbench_ahb_multilayer_synthesis_struct.vhd
-- Created by HDL-SCHEM-Editor at Wed Oct 15 18:22:19 2025
architecture struct of testbench_ahb_multilayer_synthesis is
    constant c_master_idle : t_ahb_control := (
            haddr     => (g_addr_width-1 downto 0 => '0'),
            hwrite    => '0',
            hsize     => "000",
            hburst    => (g_hburst_width-1 downto 0 => '0'),
            hprot     => (g_hprot_width-1 downto 0 => '0'),
            htrans    => "00",
            hmastlock => '0');
    signal master_hcontrol : t_ahb_control_array (g_number_of_masters-1 downto 0)(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
    signal master_hrdata   : t_std_logic_vector_list (g_number_of_masters-1 downto 0)(g_data_width-1 downto 0);
    signal master_hready   : std_logic_vector (g_number_of_masters-1 downto 0);
    signal master_hresp    : std_logic_vector (g_number_of_masters-1 downto 0);
    signal master_hwdata   : t_std_logic_vector_list (g_number_of_masters-1 downto 0)(g_data_width-1 downto 0);
    signal slave_hcontrol  : t_ahb_control_array(g_number_of_slaves-1 downto 0)(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
    signal slave_hrdata    : t_std_logic_vector_list(g_number_of_slaves-1 downto 0)(g_data_width-1 downto 0);
    signal slave_hready    : std_logic_vector (g_number_of_slaves-1 downto 0);
    signal slave_hreadyout : std_logic_vector (g_number_of_slaves-1 downto 0);
    signal slave_hresp     : std_logic_vector (g_number_of_slaves-1 downto 0);
    signal slave_hsel      : std_logic_vector (g_number_of_slaves-1 downto 0);
    signal slave_hwdata    : t_std_logic_vector_list (g_number_of_slaves-1 downto 0)(g_data_width-1 downto 0);
    component ahb_multilayer is
        generic (
            g_number_of_masters   : positive :=  3;
            g_number_of_slaves    : positive :=  2;
            g_addr_width          : positive := 32;
            g_hburst_width        : natural  :=  3;
            g_hprot_width         : natural  :=  4;
            g_data_width          : positive := 32;
            g_slave_address_width : t_positive_list(0 to g_number_of_slaves-1) := (12, 8);
            g_start_addresses     : t_std_logic_vector_list(0 to g_number_of_slaves-1)(g_addr_width-1 downto 0) := (x"00001000", x"00003400") 
        );
        port (
            hclk_i      : in  std_logic  ;
            hcontrol_i  : in  t_ahb_control_array (g_number_of_masters-1 downto 0) (haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
            hrdata_i    : in  t_std_logic_vector_list (g_number_of_slaves-1 downto 0)(g_data_width-1 downto 0) ;
            hreadyout_i : in  std_logic_vector (g_number_of_slaves-1 downto 0) ;
            hresetn_i   : in  std_logic  ;
            hresp_i     : in  std_logic_vector (g_number_of_slaves-1 downto 0) ;
            hwdata_i    : in  t_std_logic_vector_list (g_number_of_masters-1 downto 0)(g_data_width-1 downto 0) ;
            hcontrol_o  : out t_ahb_control_array (g_number_of_slaves-1 downto 0) (haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
            hrdata_o    : out t_std_logic_vector_list (g_number_of_masters-1 downto 0)(g_data_width-1 downto 0) ;
            hready_o    : out std_logic_vector (g_number_of_masters-1 downto 0) ;
            hreadyin_o  : out std_logic_vector (g_number_of_slaves-1 downto 0) ;
            hresp_o     : out std_logic_vector (g_number_of_masters-1 downto 0) ;
            hsel_o      : out std_logic_vector (g_number_of_slaves-1 downto 0) ;
            hwdata_o    : out t_std_logic_vector_list (g_number_of_slaves-1 downto 0)(g_data_width-1 downto 0) 
        );
    end component;
begin
    ahb_multilayer_inst : ahb_multilayer
        generic map (
            g_number_of_slaves    => g_number_of_slaves,
            g_addr_width          => g_addr_width,
            g_hburst_width        => g_hburst_width,
            g_hprot_width         => g_hprot_width,
            g_data_width          => g_data_width,
            g_slave_address_width => g_slave_address_width,
            g_number_of_masters   => g_number_of_masters,
            g_start_addresses     => g_start_addresses 
        )
        port map (
            hclk_i      => hclk_i,
            hcontrol_i  => master_hcontrol,
            hrdata_i    => slave_hrdata,
            hreadyout_i => slave_hreadyout,
            hresetn_i   => hresetn_i,
            hresp_i     => slave_hresp,
            hwdata_i    => master_hwdata,
            hcontrol_o  => slave_hcontrol,
            hrdata_o    => master_hrdata,
            hready_o    => master_hready,
            hreadyin_o  => slave_hready,
            hresp_o     => master_hresp,
            hsel_o      => slave_hsel,
            hwdata_o    => slave_hwdata
        );
    process(hresetn_i, hclk_i)
    begin
        if hresetn_i='0' then
            master_hcontrol <= (others => c_master_idle);
            master_hwdata   <= (others => (others => '0'));
        elsif rising_edge(hclk_i) then
            master_hcontrol <= master_hcontrol_i;
            master_hwdata   <= master_hwdata_i;
        end if;
    end process;
    process(hresetn_i, hclk_i)
    begin
        if hresetn_i='0' then
            master_hready_o <= (others => '1');
            master_hresp_o  <= (others => '0');
            master_hrdata_o <= (others => (others => '0'));
        elsif rising_edge(hclk_i) then
            master_hready_o <= master_hready;
            master_hresp_o  <= master_hresp;
            master_hrdata_o <= master_hrdata;
        end if;
    end process;
    process(hresetn_i, hclk_i)
    begin
        if hresetn_i='0' then
            slave_hsel_o     <= (others => '0');
            slave_hcontrol_o <= (others => c_master_idle);
            slave_hwdata_o   <= (others => (others => '0'));
            slave_hready_o   <= (others => '0');
        elsif rising_edge(hclk_i) then
            slave_hsel_o     <= slave_hsel;
            slave_hcontrol_o <= slave_hcontrol;
            slave_hwdata_o   <= slave_hwdata;
            slave_hready_o   <= slave_hready;
        end if;
    end process;
    process(hresetn_i, hclk_i)
    begin
        if hresetn_i='0' then
            slave_hreadyout <= (others => '1');
            slave_hresp     <= (others => '0');
            slave_hrdata    <= (others => (others => '0'));
        elsif rising_edge(hclk_i) then
            slave_hreadyout <= slave_hreadyout_i;
            slave_hresp     <= slave_hresp_i;
            slave_hrdata    <= slave_hrdata_i;
        end if;
    end process;
end architecture;
