-- Filename: ahb_multilayer_struct.vhd
-- Created by HDL-SCHEM-Editor at Fri Nov 21 15:00:39 2025
architecture struct of ahb_multilayer is
    signal create_err_response : std_logic_vector(g_number_of_masters-1 downto 0);
    signal delay_access        : std_logic_vector(g_number_of_masters-1 downto 0);
    signal delay_access_all    : t_std_logic_vector_list(g_number_of_slaves downto 0)(g_number_of_masters-1 downto 0);
    signal hcontrol            : t_ahb_control_array(g_number_of_masters-1 downto 0)(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
    signal hrdata_all          : t_std_logic_vector_matrix(g_number_of_slaves downto 0)(g_number_of_masters-1 downto 0)(g_data_width-1 downto 0);
    signal hready              : std_logic_vector(g_number_of_masters-1 downto 0);
    signal hreadyout_all       : t_std_logic_vector_list(g_number_of_slaves downto 0)(g_number_of_masters-1 downto 0);
    signal hresp_all           : t_std_logic_vector_list(g_number_of_slaves downto 0)(g_number_of_masters-1 downto 0);
    signal hsel                : t_std_logic_vector_list(g_number_of_masters-1 downto 0)(g_number_of_slaves-1 downto 0);
    signal hsel_all            : t_std_logic_vector_list(g_number_of_slaves-1 downto 0)(g_number_of_masters-1 downto 0);
    component ahb_multilayer_slave_interface is
        generic (
            g_number_of_masters : positive := 3;
            g_addr_width        : positive := 16;
            g_hburst_width      : natural  := 3;
            g_hprot_width       : natural  := 4;
            g_data_width        : positive := 8 
        );
        port (
            hclk_i         : in  std_logic  ;
            hcontrol_i     : in  t_ahb_control_array (g_number_of_masters-1 downto 0) (haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
            hrdata_i       : in  std_logic_vector (g_data_width-1 downto 0) ;
            hready_i       : in  std_logic_vector (g_number_of_masters-1 downto 0) ;
            hreadyout_i    : in  std_logic  ;
            hresetn_i      : in  std_logic  ;
            hresp_i        : in  std_logic  ;
            hsel_i         : in  std_logic_vector (g_number_of_masters-1 downto 0) ;
            hwdata_i       : in  t_std_logic_vector_list (g_number_of_masters-1 downto 0)(g_data_width-1 downto 0) ;
            delay_access_o : out std_logic_vector (g_number_of_masters-1 downto 0) ;
            hcontrol_o     : out t_ahb_control  (haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
            hrdata_o       : out t_std_logic_vector_list (g_number_of_masters-1 downto 0)(g_data_width-1 downto 0) ;
            hreadyin_o     : out std_logic  ;
            hreadyout_o    : out std_logic_vector (g_number_of_masters-1 downto 0) ;
            hresp_o        : out std_logic_vector (g_number_of_masters-1 downto 0) ;
            hsel_o         : out std_logic  ;
            hwdata_o       : out std_logic_vector (g_data_width-1 downto 0) 
        );
    end component;
    component ahb_multilayer_master_interface is
        generic (
            g_number_of_slaves    : positive := 2;
            g_addr_width          : positive := 16;
            g_hburst_width        : natural  := 3;
            g_hprot_width         : natural  := 4;
            g_data_width          : positive := 8;
            g_slave_address_width : t_positive_list(0 to g_number_of_slaves-1) := (12, 8);
            g_start_addresses     : t_std_logic_vector_list(0 to g_number_of_slaves-1)(g_addr_width-1 downto 0) := (x"1000", x"3400") 
        );
        port (
            delay_access_i        : in  std_logic  ;
            hclk_i                : in  std_logic  ;
            hcontrol_i            : in  t_ahb_control  (haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
            hready_i              : in  std_logic  ;
            hresetn_i             : in  std_logic  ;
            create_err_response_o : out std_logic  ;
            hcontrol_o            : out t_ahb_control  (haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
            hready_o              : out std_logic  ;
            hsel_o                : out std_logic_vector (g_number_of_slaves-1 downto 0) 
        );
    end component;
    component ahb_multilayer_interconnect_slave_response is
        generic (
            g_number_of_masters   : positive := 3;
            g_number_of_slaves    : positive := 2;
            g_data_width          : positive := 8
        );
        port (
            delay_access_all_i : in  t_std_logic_vector_list (g_number_of_slaves-1 downto 0)(g_number_of_masters-1 downto 0) ;
            hrdata_all_i       : in  t_std_logic_vector_matrix (g_number_of_slaves-1 downto 0)(g_number_of_masters-1 downto 0)(g_data_width-1 downto 0) ;
            hreadyout_all_i    : in  t_std_logic_vector_list (g_number_of_slaves-1 downto 0)(g_number_of_masters-1 downto 0) ;
            hresp_all_i        : in  t_std_logic_vector_list (g_number_of_slaves-1 downto 0)(g_number_of_masters-1 downto 0) ;
            delay_access_o     : out std_logic_vector (g_number_of_masters-1 downto 0) ;
            hrdata_o           : out t_std_logic_vector_list (g_number_of_masters-1 downto 0)(g_data_width-1 downto 0) ;
            hready_o           : out std_logic_vector (g_number_of_masters-1 downto 0) ;
            hresp_o            : out std_logic_vector (g_number_of_masters-1 downto 0) 
        );
    end component;
    component ahb_multilayer_interconnect_hsel is
        generic (
            g_number_of_masters   : positive := 3;
            g_number_of_slaves    : positive := 2 
        );
        port (
            hsel_i     : in  t_std_logic_vector_list (g_number_of_masters-1 downto 0)(g_number_of_slaves-1 downto 0) ;
            hsel_all_o : out t_std_logic_vector_list (g_number_of_slaves-1 downto 0)(g_number_of_masters-1 downto 0) 
        );
    end component;
    component ahb_multilayer_default_slave is
        generic (
            g_data_width : positive := 32
        );
        port (
            create_err_response_i : in  std_logic  ;
            hclk_i                : in  std_logic  ;
            hresetn_i             : in  std_logic  ;
            delay_access_o        : out std_logic  ;
            hrdata_o              : out std_logic_vector (g_data_width-1 downto 0) ;
            hreadyout_o           : out std_logic  ;
            hresp_o               : out std_logic  
        );
    end component;
begin
    ahb_multilayer_master_interface_g: for i in 0 to g_number_of_masters-1 generate
        ahb_multilayer_master_interface_inst : ahb_multilayer_master_interface
            generic map (
                g_number_of_slaves    => g_number_of_slaves,
                g_addr_width          => g_addr_width,
                g_hburst_width        => g_hburst_width,
                g_hprot_width         => g_hprot_width,
                g_data_width          => g_data_width,
                g_slave_address_width => g_slave_address_width,
                g_start_addresses     => g_start_addresses
            )
            port map (
                delay_access_i        => delay_access(i),
                hclk_i                => hclk_i,
                hcontrol_i            => hcontrol_i(i),
                hready_i              => hready(i),
                hresetn_i             => hresetn_i,
                create_err_response_o => create_err_response(i),
                hcontrol_o            => hcontrol(i),
                hready_o              => hready_o(i),
                hsel_o                => hsel(i)
            );
    end generate ahb_multilayer_master_interface_g;
    ahb_multilayer_interconnect_hsel_inst : ahb_multilayer_interconnect_hsel
        generic map (
            g_number_of_masters => g_number_of_masters,
            g_number_of_slaves  => g_number_of_slaves
        )
        port map (
            hsel_i     => hsel,
            hsel_all_o => hsel_all
        );
    ahb_multilayer_slave_interface_g: for i in 0 to g_number_of_slaves-1 generate
        ahb_multilayer_slave_interface_inst : ahb_multilayer_slave_interface
            generic map (
                g_number_of_masters => g_number_of_masters,
                g_addr_width        => g_addr_width,
                g_hburst_width      => g_hburst_width,
                g_hprot_width       => g_hprot_width,
                g_data_width        => g_data_width 
            )
            port map (
                hclk_i         => hclk_i,
                hcontrol_i     => hcontrol,
                hrdata_i       => hrdata_i(i),
                hready_i       => hready,
                hreadyout_i    => hreadyout_i(i),
                hresetn_i      => hresetn_i,
                hresp_i        => hresp_i(i),
                hsel_i         => hsel_all(i),
                hwdata_i       => hwdata_i,
                delay_access_o => delay_access_all(i),
                hcontrol_o     => hcontrol_o(i),
                hrdata_o       => hrdata_all(i),
                hreadyin_o     => hreadyin_o(i),
                hreadyout_o    => hreadyout_all(i),
                hresp_o        => hresp_all(i),
                hsel_o         => hsel_o(i),
                hwdata_o       => hwdata_o(i)
            );
    end generate ahb_multilayer_slave_interface_g;
    ahb_multilayer_default_slave_g: for m in 0 to g_number_of_masters-1 generate
        ahb_multilayer_default_slave_inst : ahb_multilayer_default_slave
            generic map (
                g_data_width => g_data_width
            )
            port map (
                create_err_response_i => create_err_response(m),
                hclk_i                => hclk_i,
                hresetn_i             => hresetn_i,
                delay_access_o        => delay_access_all(g_number_of_slaves)(m),
                hrdata_o              => hrdata_all(g_number_of_slaves)(m),
                hreadyout_o           => hreadyout_all(g_number_of_slaves)(m),
                hresp_o               => hresp_all(g_number_of_slaves)(m)
            );
    end generate ahb_multilayer_default_slave_g;
    ahb_multilayer_interconnect_slave_response_inst : ahb_multilayer_interconnect_slave_response
        generic map (
            g_number_of_masters => g_number_of_masters,
            g_number_of_slaves  => g_number_of_slaves+1,
            g_data_width        => g_data_width
        )
        port map (
            delay_access_all_i => delay_access_all,
            hrdata_all_i       => hrdata_all,
            hreadyout_all_i    => hreadyout_all,
            hresp_all_i        => hresp_all,
            delay_access_o     => delay_access,
            hrdata_o           => hrdata_o,
            hready_o           => hready,
            hresp_o            => hresp_o
        );
end architecture;
