-- Filename: ahb_multilayer_mux_hwdata_struct.vhd
-- Created by HDL-SCHEM-Editor at Fri Nov 21 15:00:42 2025
architecture struct of ahb_multilayer_mux_hwdata is
    signal hwdata : t_std_logic_vector_list(g_number_of_masters-1 downto 0)(g_data_width-1 downto 0);
begin
    -- Set all hwdata values to 0, except the hwdata from the selected master:
    process(grant_s_i, hwdata_i)
    begin
        for i in 0 to g_number_of_masters-1 loop
            if grant_s_i(i)='1' then
                hwdata(i) <= hwdata_i(i);
            else
                hwdata(i) <= (others => '0');
            end if;
        end loop;
    end process;
    -- "Or" all hwdata values:
    process (hwdata)
        variable v_hwdata : std_logic_vector(g_data_width-1 downto 0);
    begin
        v_hwdata := (others => '0');
        for i in 0 to g_number_of_masters-1 loop
            v_hwdata := v_hwdata or hwdata(i);
        end loop;
        hwdata_o <= v_hwdata;
    end process;
end architecture;
