-- Filename: ahb_multilayer_mux_hcontrol_struct.vhd
-- Created by HDL-SCHEM-Editor at Fri Nov 21 15:00:42 2025
architecture struct of ahb_multilayer_mux_hcontrol is
    constant c_master_idle : t_ahb_control := (
            haddr     => (g_addr_width-1 downto 0 => '0'),
            hwrite    => '0',
            hsize     => "000",
            hburst    => (g_hburst_width-1 downto 0 => '0'),
            hprot     => (g_hprot_width-1 downto 0 => '0'),
            htrans    => "00",
            hmastlock => '0');
    signal hcontrol : t_ahb_control_array(g_number_of_masters-1 downto 0)(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
begin
    -- Set all hcontrol records to 0, except the hcontrol from the selected master:
    process(grant_i, hcontrol_i)
    begin
        for i in 0 to g_number_of_masters-1 loop
            if grant_i(i)='1' then
                hcontrol(i) <= hcontrol_i(i);
            else
                hcontrol(i) <= c_master_idle;
            end if;
        end loop;
    end process;
    -- "Or" all hcontrol values:
    process (hcontrol)
        variable v_hcontrol : t_ahb_control(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
    begin
        v_hcontrol := c_master_idle;
        for i in 0 to g_number_of_masters-1 loop
            v_hcontrol := v_hcontrol or hcontrol(i);
        end loop;
        hcontrol_o <= v_hcontrol;
    end process;
end architecture;
