-- Filename: ahb_multilayer_mux_hcontrol_e.vhd
-- Created by HDL-SCHEM-Editor at Fri Nov 21 15:00:42 2025
library ieee;
use ieee.std_logic_1164.all;
use work.ahb_package.all;
entity ahb_multilayer_mux_hcontrol is
    generic (
        g_number_of_masters : positive := 3;
        g_addr_width        : positive := 16;
        g_hburst_width      : natural  := 3;
        g_hprot_width       : natural  := 4;
        g_data_width        : positive := 8 
    );
    port (
        grant_i    : in  std_logic_vector(g_number_of_masters-1 downto 0);
        hcontrol_i : in  t_ahb_control_array(g_number_of_masters-1 downto 0)(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
        hcontrol_o : out t_ahb_control(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0))
    );
end entity ahb_multilayer_mux_hcontrol;
