-- Filename: ahb_multilayer_master_interface_e.vhd
-- Created by HDL-SCHEM-Editor at Fri Nov 21 15:10:29 2025
library ieee;
use ieee.std_logic_1164.all;
use work.ahb_package.all;
entity ahb_multilayer_master_interface is
    generic (
        g_number_of_slaves    : positive := 2;
        g_addr_width          : positive := 16;
        g_hburst_width        : natural  := 3;
        g_hprot_width         : natural  := 4;
        g_data_width          : positive := 8;
        g_slave_address_width : t_positive_list(0 to g_number_of_slaves-1) := (12, 8);
        g_start_addresses     : t_std_logic_vector_list(0 to g_number_of_slaves-1)(g_addr_width-1 downto 0) := (X"1000", X"3400") 
    );
    port (
        delay_access_i        : in  std_logic;
        hclk_i                : in  std_logic;
        hcontrol_i            : in  t_ahb_control(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
        hready_i              : in  std_logic;
        hresetn_i             : in  std_logic;
        create_err_response_o : out std_logic;
        hcontrol_o            : out t_ahb_control(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
        hready_o              : out std_logic;
        hsel_o                : out std_logic_vector(g_number_of_slaves-1 downto 0)
    );
end entity ahb_multilayer_master_interface;
