-- Filename: ahb_multilayer_interconnect_slave_response_struct.vhd
-- Created by HDL-SCHEM-Editor at Fri Nov 21 15:00:41 2025
architecture struct of ahb_multilayer_interconnect_slave_response is
begin
    process(hreadyout_all_i)
        variable v_hready : std_logic;
    begin
        for m in 0 to g_number_of_masters-1 loop
            v_hready := '1';
            -- Build the hready for master m by
            -- checking all slave hreadyouts for this master:
            for s in 0 to g_number_of_slaves-1 loop
                v_hready := v_hready and hreadyout_all_i(s)(m);
            end loop;
            hready_o(m) <= v_hready;
        end loop;
    end process;
    
    process(hresp_all_i)
        variable v_instage_hresp : std_logic;
    begin
        for m in 0 to g_number_of_masters-1 loop
            v_instage_hresp := '0';
            for s in 0 to g_number_of_slaves-1 loop
                v_instage_hresp := v_instage_hresp or hresp_all_i(s)(m);
            end loop;
            hresp_o(m) <= v_instage_hresp;
        end loop;
    end process;
    
    process(hrdata_all_i)
        variable v_instage_hrdata : std_logic_vector(g_data_width-1 downto 0);
    begin
        for m in 0 to g_number_of_masters-1 loop
            v_instage_hrdata := (others => '0');
            for s in 0 to g_number_of_slaves-1 loop
                v_instage_hrdata := v_instage_hrdata or hrdata_all_i(s)(m);
            end loop;
            hrdata_o(m) <= v_instage_hrdata;
        end loop;
    end process;
    
    process(delay_access_all_i)
        variable v_delay_access : std_logic;
    begin
        for m in 0 to g_number_of_masters-1 loop
            v_delay_access := '0';
            for s in 0 to g_number_of_slaves-1 loop
                v_delay_access := v_delay_access or delay_access_all_i(s)(m);
            end loop;
            delay_access_o(m) <= v_delay_access;
        end loop;
    end process;
end architecture;
