-- Filename: ahb_multilayer_e.vhd
-- Created by HDL-SCHEM-Editor at Fri Nov 21 15:00:39 2025
--
-- The ahb_multilayer complies with the AMBA AHB Protocol Specification (ARM IHI 0033C).
-- The ahb_multilayer implements the AHB-Lite protocol, named "Issue A" in the specification.
-- In contrary to the AHB-Lite protocol the width of the address bus can be configured.
--
library ieee;
use ieee.std_logic_1164.all;
use work.ahb_package.all;
entity ahb_multilayer is
    generic (
        g_number_of_masters   : positive :=  3;
        g_number_of_slaves    : positive :=  2;
        g_addr_width          : positive := 32;
        g_hburst_width        : natural  :=  3;
        g_hprot_width         : natural  :=  4;
        g_data_width          : positive := 32;
        g_slave_address_width : t_positive_list(0 to g_number_of_slaves-1) := (12, 8);
        g_start_addresses     : t_std_logic_vector_list(0 to g_number_of_slaves-1)(g_addr_width-1 downto 0) := (X"00001000", X"00003400") 
    );
    port (
        hclk_i      : in  std_logic;
        hcontrol_i  : in  t_ahb_control_array(g_number_of_masters-1 downto 0)(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
        hrdata_i    : in  t_std_logic_vector_list(g_number_of_slaves-1 downto 0)(g_data_width-1 downto 0);
        hreadyout_i : in  std_logic_vector(g_number_of_slaves-1 downto 0);
        hresetn_i   : in  std_logic;
        hresp_i     : in  std_logic_vector(g_number_of_slaves-1 downto 0);
        hwdata_i    : in  t_std_logic_vector_list(g_number_of_masters-1 downto 0)(g_data_width-1 downto 0);
        hcontrol_o  : out t_ahb_control_array(g_number_of_slaves-1 downto 0)(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
        hrdata_o    : out t_std_logic_vector_list(g_number_of_masters-1 downto 0)(g_data_width-1 downto 0);
        hready_o    : out std_logic_vector(g_number_of_masters-1 downto 0);
        hreadyin_o  : out std_logic_vector(g_number_of_slaves-1 downto 0);
        hresp_o     : out std_logic_vector(g_number_of_masters-1 downto 0);
        hsel_o      : out std_logic_vector(g_number_of_slaves-1 downto 0);
        hwdata_o    : out t_std_logic_vector_list(g_number_of_slaves-1 downto 0)(g_data_width-1 downto 0)
    );
end entity ahb_multilayer;
