-- Filename: ahb_multilayer_detect_request_e.vhd
-- Created by HDL-SCHEM-Editor at Fri Nov 21 15:00:43 2025
library ieee;
use ieee.std_logic_1164.all;
use work.ahb_package.all;
entity ahb_multilayer_detect_request is
    generic (
        g_number_of_masters : positive := 3;
        g_addr_width        : positive := 16;
        g_hburst_width      : natural  := 3;
        g_hprot_width       : natural  := 4 

    );
    port (
        grant_i          : in  std_logic_vector(g_number_of_masters-1 downto 0);
        hclk_i           : in  std_logic;
        hcontrol_i       : in  t_ahb_control_array(g_number_of_masters-1 downto 0)(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
        hready_i         : in  std_logic;
        hresetn_i        : in  std_logic;
        hsel_i           : in  std_logic_vector(g_number_of_masters-1 downto 0);
        request_o        : out std_logic_vector(g_number_of_masters-1 downto 0);
        use_last_grant_o : out std_logic_vector (g_number_of_masters-1 downto 0)
    );
end entity ahb_multilayer_detect_request;
