-- Filename: ahb_multilayer_arbiter_e.vhd
-- Created by HDL-SCHEM-Editor at Fri Nov 21 15:00:41 2025
-- The ahb_arbiter observes all request inputs and gives a grant to only 1 requester.
-- The ahb_arbiter answers to a request in the same clock cycle (by combinatorial logic).
-- The ahb_arbiter works with an ascending "Round Robin" arbitration scheme (grant moves
-- from lower to higher indices).
-- When a request was answered with a grant in a valid AHB address phase (hready_i=1) and
-- the same request remains active in the next clock cycle, the same grant is only
-- activated again if this new request continues a running burst or lock access.
-- Otherwise the grant is handed over to another request (if there is any).
-- If hready_i is 0 in a clock cycle, then this clock cycle is not a valid AHB address
-- phase and the arbiter will activate the same grant in the next clock cycle again, if
-- the actual high priorest access still is active in the next clock cycle.
library ieee;
use ieee.std_logic_1164.all;
entity ahb_multilayer_arbiter is
    generic (
        g_number_of_masters : positive := 2
    );
    port (
        hclk_i           : in  std_logic;
        hready_i         : in  std_logic;
        hresetn_i        : in  std_logic;
        request_i        : in  std_logic_vector(g_number_of_masters-1 downto 0);
        use_last_grant_i : in  std_logic_vector(g_number_of_masters-1 downto 0);
        grant_o          : out std_logic_vector(g_number_of_masters-1 downto 0);
        grant_s_o        : out std_logic_vector(g_number_of_masters-1 downto 0)
    );
end entity ahb_multilayer_arbiter;
