-- Filename: ahb_multilayer_slave_interface_e.vhd
-- Created by HDL-SCHEM-Editor at Wed Oct 15 18:45:17 2025
--
-- Example for an access with wait:
--
-- ahb_multilayer_instage | idle | idle | idle | store| store| store| idle | idle |
-- hready_i(m) ...        |------|______|------|_____________|------|______|------|
-- ... driven by:                 <- acc1    -> <- slave-  -> <- acc2           ->      
--                                                 interface
-- hsel_i(m)              |______|----------------------------------|
-- hcontrol_i(m)          | acc1 | acc2 | acc2 | acc2 | acc2 | acc2 | acc3 | acc3 |
-- hwdata_i(m)            |      |  w1                              |  w2         |
--
-- request(m)             |______|----------------------------------|_____________|
-- grant(m)               |xxxxxx|___________________________|------|_____________|  
-- grant_s(m)             |xxxxxx|__________________________________|-------------|
--
-- hcontrol_o             | xxxx | xxxx | xxxx | xxxx | xxxx | acc2 | xxxx | xxxx |
-- hreadyout_i            |xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx|------|______|------|
--
-- hreadyout_o(m)         |--------------------|_____________|------|______|------|
--
-- delay_access_o         |_____________|------|__________________________________|

library ieee;
use ieee.std_logic_1164.all;
use work.ahb_multilayer_package.all;
entity ahb_multilayer_slave_interface is
    generic (
        g_number_of_masters : positive := 3;
        g_addr_width        : positive := 16;
        g_hburst_width      : natural  := 3;
        g_hprot_width       : natural  := 4;
        g_data_width        : positive := 8 
    );
    port (
        hclk_i         : in  std_logic;
        hcontrol_i     : in  t_ahb_control_array(g_number_of_masters-1 downto 0)(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
        hrdata_i       : in  std_logic_vector(g_data_width-1 downto 0);
        hready_i       : in  std_logic_vector(g_number_of_masters-1 downto 0);
        hreadyout_i    : in  std_logic;
        hresetn_i      : in  std_logic;
        hresp_i        : in  std_logic;
        hsel_i         : in  std_logic_vector(g_number_of_masters-1 downto 0);
        hwdata_i       : in  t_std_logic_vector_list(g_number_of_masters-1 downto 0)(g_data_width-1 downto 0);
        delay_access_o : out std_logic_vector(g_number_of_masters-1 downto 0);
        hcontrol_o     : out t_ahb_control(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
        hrdata_o       : out t_std_logic_vector_list(g_number_of_masters-1 downto 0)(g_data_width-1 downto 0);
        hreadyin_o     : out std_logic;
        hreadyout_o    : out std_logic_vector(g_number_of_masters-1 downto 0);
        hresp_o        : out std_logic_vector(g_number_of_masters-1 downto 0);
        hsel_o         : out std_logic;
        hwdata_o       : out std_logic_vector(g_data_width-1 downto 0)
    );
end entity ahb_multilayer_slave_interface;
