-- Filename: ahb_multilayer_mux_hready_struct.vhd
-- Created by HDL-SCHEM-Editor at Thu Oct 16 10:32:30 2025
architecture struct of ahb_multilayer_mux_hready is
    signal hready : std_logic_vector(g_number_of_masters-1 downto 0);
begin
    -- Set all hready values to 1, except the hready from the selected master:
    process(grant_i, hready_i)
    begin
        for i in 0 to g_number_of_masters-1 loop
            if grant_i(i)='1' then
                hready(i) <= hready_i(i);
            else
                hready(i) <= '1';
            end if;
        end loop;
    end process;
    -- "And" all hready values:
    process (hready)
        variable v_hready : std_logic;
    begin
        v_hready := '1';
        for i in 0 to g_number_of_masters-1 loop
            v_hready := v_hready and hready(i);
        end loop;
        hready_o <= v_hready;
    end process;
end architecture;
