-- Filename: ahb_multilayer_master_interface_struct.vhd
-- Created by HDL-SCHEM-Editor at Thu Oct 16 08:56:58 2025
architecture struct of ahb_multilayer_master_interface is
    signal hcontrol : t_ahb_control(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
    component ahb_multilayer_instage is
        generic (
            g_addr_width   : positive := 16;
            g_hburst_width : natural  := 16;
            g_hprot_width  : natural  := 16;
            g_data_width   : positive :=  8
        );
        port (
            delay_access_i : in  std_logic  ;
            hclk_i         : in  std_logic  ;
            hcontrol_i     : in  t_ahb_control  (haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
            hready_i       : in  std_logic  ;
            hresetn_i      : in  std_logic  ;
            hcontrol_o     : out t_ahb_control  (haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
            hready_o       : out std_logic  
        );
    end component;
    component ahb_multilayer_decoder is
        generic (
            g_number_of_slaves    : positive :=  2;
            g_addr_width          : positive := 16;
            g_hburst_width        : natural  :=  3;
            g_hprot_width         : natural  :=  4;
            g_slave_address_width : t_positive_list(0 to g_number_of_slaves-1) := (12, 8);
            g_start_addresses     : t_std_logic_vector_list(0 to g_number_of_slaves-1)(g_addr_width-1 downto 0) := (x"0000", x"1000") 
        );
        port (
            hcontrol_i            : in  t_ahb_control  (haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
            create_err_response_o : out std_logic  ;
            hsel_o                : out std_logic_vector (g_number_of_slaves-1 downto 0) 
        );
    end component;
begin
    ahb_multilayer_instage_inst : ahb_multilayer_instage
        generic map (
            g_addr_width   => g_addr_width,
            g_hburst_width => g_hburst_width,
            g_hprot_width  => g_hprot_width,
            g_data_width   => g_data_width
        )
        port map (
            delay_access_i => delay_access_i,
            hclk_i         => hclk_i,
            hcontrol_i     => hcontrol_i,
            hready_i       => hready_i,
            hresetn_i      => hresetn_i,
            hcontrol_o     => hcontrol,
            hready_o       => hready_o
        );
    hcontrol_o <= hcontrol;
    ahb_multilayer_decoder_inst : ahb_multilayer_decoder
        generic map (
            g_number_of_slaves    => g_number_of_slaves,
            g_addr_width          => g_addr_width,
            g_hburst_width        => g_hburst_width,
            g_hprot_width         => g_hprot_width,
            g_slave_address_width => g_slave_address_width,
            g_start_addresses     => g_start_addresses
        )
        port map (
            hcontrol_i            => hcontrol,
            create_err_response_o => create_err_response_o,
            hsel_o                => hsel_o
        );
end architecture;
