-- Filename: ahb_multilayer_decoder_e.vhd
-- Created by HDL-SCHEM-Editor at Wed Oct 15 18:45:23 2025
library ieee;
use ieee.std_logic_1164.all;
use work.ahb_multilayer_package.all;
entity ahb_multilayer_decoder is
    generic (
        g_number_of_slaves    : positive :=  2;
        g_addr_width          : positive := 16;
        g_hburst_width        : natural  :=  3;
        g_hprot_width         : natural  :=  4;
        g_slave_address_width : t_positive_list(0 to g_number_of_slaves-1) := (12, 8);
        g_start_addresses     : t_std_logic_vector_list(0 to g_number_of_slaves-1)(g_addr_width-1 downto 0) := (X"0000", X"1000") 
    );
    port (
        hcontrol_i            : in  t_ahb_control(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
        create_err_response_o : out std_logic;
        hsel_o                : out std_logic_vector(g_number_of_slaves-1 downto 0)
    );
end entity ahb_multilayer_decoder;
