-- Filename: ahb_multilayer_slave_interface_struct.vhd
-- Created by HDL-SCHEM-Editor at Wed Oct 15 18:45:17 2025
architecture struct of ahb_multilayer_slave_interface is
    constant c_master_idle : t_ahb_control := (
            haddr     => (g_addr_width-1 downto 0 => '0'),
            hwrite    => '0',
            hsize     => "000",
            hburst    => (g_hburst_width-1 downto 0 => '0'),
            hprot     => (g_hprot_width-1 downto 0 => '0'),
            htrans    => "00",
            hmastlock => '0');
    signal grant          : std_logic_vector (g_number_of_masters-1 downto 0);
    signal grant_s        : std_logic_vector (g_number_of_masters-1 downto 0);
    signal hready         : std_logic;
    signal request        : std_logic_vector(g_number_of_masters-1 downto 0);
    signal use_last_grant : std_logic_vector (g_number_of_masters-1 downto 0);
    component ahb_multilayer_arbiter is
        generic (
            g_number_of_masters : positive := 2
        );
        port (
            hclk_i           : in  std_logic  ;
            hready_i         : in  std_logic  ;
            hresetn_i        : in  std_logic  ;
            request_i        : in  std_logic_vector (g_number_of_masters-1 downto 0) ;
            use_last_grant_i : in  std_logic_vector (g_number_of_masters-1 downto 0) ;
            grant_o          : out std_logic_vector (g_number_of_masters-1 downto 0) ;
            grant_s_o        : out std_logic_vector (g_number_of_masters-1 downto 0) 
        );
    end component;
    component ahb_multilayer_mux_hwdata is
        generic (
            g_number_of_masters : positive := 3;
            g_data_width        : positive := 32
        );
        port (
            grant_s_i : in  std_logic_vector (g_number_of_masters-1 downto 0) ;
            hwdata_i  : in  t_std_logic_vector_list (g_number_of_masters-1 downto 0)(g_data_width-1 downto 0) ;
            hwdata_o  : out std_logic_vector (g_data_width-1 downto 0) 
        );
    end component;
    component ahb_multilayer_mux_hcontrol is
        generic (
            g_number_of_masters : positive := 3;
            g_addr_width        : positive := 16;
            g_hburst_width      : natural  := 3;
            g_hprot_width       : natural  := 4;
            g_data_width        : positive := 8 
        );
        port (
            grant_i    : in  std_logic_vector (g_number_of_masters-1 downto 0) ;
            hcontrol_i : in  t_ahb_control_array (g_number_of_masters-1 downto 0) (haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
            hcontrol_o : out t_ahb_control  (haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0))
        );
    end component;
    component ahb_multilayer_demux_hrdata is
        generic (
            g_number_of_masters : positive := 3;
            g_data_width        : positive := 32
        );
        port (
            grant_s_i : in  std_logic_vector (g_number_of_masters-1 downto 0) ;
            hrdata_i  : in  std_logic_vector (g_data_width-1 downto 0) ;
            hrdata_o  : out t_std_logic_vector_list (g_number_of_masters-1 downto 0)(g_data_width-1 downto 0) 
        );
    end component;
    component ahb_multilayer_demux_hresp is
        generic (
            g_number_of_masters : positive := 3
        );
        port (
            grant_s_i : in  std_logic_vector (g_number_of_masters-1 downto 0) ;
            hresp_i   : in  std_logic  ;
            hresp_o   : out std_logic_vector (g_number_of_masters-1 downto 0) 
        );
    end component;
    component ahb_multilayer_demux_hreadyout is
        generic (
            g_number_of_masters : positive := 3
        );
        port (
            grant_i        : in  std_logic_vector (g_number_of_masters-1 downto 0) ;
            grant_s_i      : in  std_logic_vector (g_number_of_masters-1 downto 0) ;
            hclk_i         : in  std_logic  ;
            hready_i       : in  std_logic_vector (g_number_of_masters-1 downto 0) ;
            hreadyout_i    : in  std_logic  ;
            hresetn_i      : in  std_logic  ;
            request_i      : in  std_logic_vector (g_number_of_masters-1 downto 0) ;
            delay_access_o : out std_logic_vector (g_number_of_masters-1 downto 0) ;
            hreadyout_o    : out std_logic_vector (g_number_of_masters-1 downto 0) 
        );
    end component;
    component ahb_multilayer_mux_hready is
        generic (
            g_number_of_masters : positive := 3
        );
        port (
            grant_i  : in  std_logic_vector (g_number_of_masters-1 downto 0) ;
            hready_i : in  std_logic_vector (g_number_of_masters-1 downto 0) ;
            hready_o : out std_logic  
        );
    end component;
    component ahb_multilayer_detect_request is
        generic (
            g_number_of_masters : positive := 3;
            g_addr_width        : positive := 16;
            g_hburst_width      : natural  := 3;
            g_hprot_width       : natural  := 4 
        );
        port (
            grant_i          : in  std_logic_vector (g_number_of_masters-1 downto 0) ;
            hclk_i           : in  std_logic  ;
            hcontrol_i       : in  t_ahb_control_array (g_number_of_masters-1 downto 0) (haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
            hready_i         : in  std_logic  ;
            hresetn_i        : in  std_logic  ;
            hsel_i           : in  std_logic_vector (g_number_of_masters-1 downto 0) ;
            request_o        : out std_logic_vector (g_number_of_masters-1 downto 0) ;
            use_last_grant_o : out std_logic_vector (g_number_of_masters-1 downto 0) 
        );
    end component;
begin
    ahb_multilayer_detect_request_inst : ahb_multilayer_detect_request
        generic map (
            g_number_of_masters => g_number_of_masters,
            g_addr_width        => g_addr_width,
            g_hburst_width      => g_hburst_width,
            g_hprot_width       => g_hprot_width 
        )
        port map (
            grant_i          => grant,
            hclk_i           => hclk_i,
            hcontrol_i       => hcontrol_i,
            hready_i         => hready,
            hresetn_i        => hresetn_i,
            hsel_i           => hsel_i,
            request_o        => request,
            use_last_grant_o => use_last_grant
        );
    -- There is a request with active hsel to this slave by at least one master.
    -- So one master will get the grant and the slave must be selected:
    hsel_o <= '1' when request/=(g_number_of_masters-1 downto 0 => '0') else '0';
    ahb_multilayer_arbiter_inst : ahb_multilayer_arbiter
        generic map (
            g_number_of_masters => g_number_of_masters
        )
        port map (
            hclk_i           => hclk_i,
            hready_i         => hready,
            hresetn_i        => hresetn_i,
            request_i        => request,
            use_last_grant_i => use_last_grant,
            grant_o          => grant,
            grant_s_o        => grant_s
        );
    ahb_multilayer_mux_hcontrol_inst : ahb_multilayer_mux_hcontrol
        generic map (
            g_number_of_masters => g_number_of_masters,
            g_addr_width        => g_addr_width,
            g_hburst_width      => g_hburst_width,
            g_hprot_width       => g_hprot_width,
            g_data_width        => g_data_width 
        )
        port map (
            grant_i    => grant,
            hcontrol_i => hcontrol_i,
            hcontrol_o => hcontrol_o
        );
    ahb_multilayer_mux_hready_inst : ahb_multilayer_mux_hready
        generic map (
            g_number_of_masters => g_number_of_masters
        )
        port map (
            grant_i  => grant,
            hready_i => hready_i,
            hready_o => hready
        );
    hreadyin_o <= hready;
    ahb_multilayer_mux_hwdata_inst : ahb_multilayer_mux_hwdata
        generic map (
            g_number_of_masters => g_number_of_masters,
            g_data_width        => g_data_width
        )
        port map (
            grant_s_i => grant_s,
            hwdata_i  => hwdata_i,
            hwdata_o  => hwdata_o
        );
    ahb_multilayer_demux_hreadyout_inst : ahb_multilayer_demux_hreadyout
        generic map (
            g_number_of_masters => g_number_of_masters
        )
        port map (
            grant_i        => grant,
            grant_s_i      => grant_s,
            hclk_i         => hclk_i,
            hready_i       => hready_i,
            hreadyout_i    => hreadyout_i,
            hresetn_i      => hresetn_i,
            request_i      => request,
            delay_access_o => delay_access_o,
            hreadyout_o    => hreadyout_o
        );
    ahb_multilayer_demux_hrdata_inst : ahb_multilayer_demux_hrdata
        generic map (
            g_number_of_masters => g_number_of_masters,
            g_data_width        => g_data_width
        )
        port map (
            grant_s_i => grant_s,
            hrdata_i  => hrdata_i,
            hrdata_o  => hrdata_o
        );
    ahb_multilayer_demux_hresp_inst : ahb_multilayer_demux_hresp
        generic map (
            g_number_of_masters => g_number_of_masters
        )
        port map (
            grant_s_i => grant_s,
            hresp_i   => hresp_i,
            hresp_o   => hresp_o
        );
end architecture;
