library ieee;
use ieee.std_logic_1164.all;
package ahb_multilayer_package is
    type t_ahb_control is record
        haddr     : std_logic_vector;
        hwrite    : std_logic;
        hsize     : std_logic_vector(2 downto 0);
        hburst    : std_logic_vector;
        hprot     : std_logic_vector;
        htrans    : std_logic_vector(1 downto 0);
        hmastlock : std_logic;
    end record;
    type t_ahb_control_array       is array (natural range <>) of t_ahb_control;
    type t_positive_list           is array (natural range <>) of positive;
    type t_std_logic_vector_list   is array (natural range <>) of std_logic_vector;
    type t_std_logic_vector_matrix is array (natural range <>) of t_std_logic_vector_list;
    function "or" (ahb_control_1 : t_ahb_control; ahb_control_2 : t_ahb_control) return t_ahb_control;
    procedure debug_record (rec_i : in t_ahb_control;
                            signal haddr_rec     : out std_logic_vector;
                            signal hsize_rec     : out std_logic_vector(2 downto 0);
                            signal hburst_rec    : out std_logic_vector;
                            signal hprot_rec     : out std_logic_vector;
                            signal htrans_rec    : out std_logic_vector(1 downto 0);
                            signal hwrite_rec    : out std_logic;
                            signal hmastlock_rec : out std_logic);
end package;
package body ahb_multilayer_package is
    function "or" (ahb_control_1 : t_ahb_control; ahb_control_2 : t_ahb_control) return t_ahb_control is
        variable ahb_control : t_ahb_control(haddr (ahb_control_1.haddr'range),
                                             hburst(ahb_control_1.hburst'range),
                                             hprot (ahb_control_1.hprot'range)
                                             );
    begin
        ahb_control.haddr     := ahb_control_1.haddr     or ahb_control_2.haddr;
        ahb_control.hsize     := ahb_control_1.hsize     or ahb_control_2.hsize;
        ahb_control.hburst    := ahb_control_1.hburst    or ahb_control_2.hburst;
        ahb_control.hprot     := ahb_control_1.hprot     or ahb_control_2.hprot;
        ahb_control.htrans    := ahb_control_1.htrans    or ahb_control_2.htrans;
        ahb_control.hwrite    := ahb_control_1.hwrite    or ahb_control_2.hwrite;
        ahb_control.hmastlock := ahb_control_1.hmastlock or ahb_control_2.hmastlock;
        return ahb_control;        
    end function;
    
    procedure debug_record (rec_i : in t_ahb_control;
                            signal haddr_rec     : out std_logic_vector;
                            signal hsize_rec     : out std_logic_vector(2 downto 0);
                            signal hburst_rec    : out std_logic_vector;
                            signal hprot_rec     : out std_logic_vector;
                            signal htrans_rec    : out std_logic_vector(1 downto 0);
                            signal hwrite_rec    : out std_logic;
                            signal hmastlock_rec : out std_logic
                            ) is
    begin
        haddr_rec     <= rec_i.haddr;
        hsize_rec     <= rec_i.hsize;
        hburst_rec    <= rec_i.hburst;
        hprot_rec     <= rec_i.hprot;
        htrans_rec    <= rec_i.htrans;
        hwrite_rec    <= rec_i.hwrite;
        hmastlock_rec <= rec_i.hmastlock;
    end procedure;
 
end package body;