-- Filename: ahb_multilayer_instage_fsm.vhd
-- Created by HDL-FSM-Editor at Thu Oct 16 08:47:10 2025

architecture fsm of ahb_multilayer_instage is
    type t_state is (store, pass);
    signal state : t_state;
    signal hcontrol_s : t_ahb_control(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
    constant c_master_idle : t_ahb_control := (
            haddr     => (g_addr_width-1 downto 0 => '0'),
            hwrite    => '0',
            hsize     => "000",
            hburst    => (g_hburst_width-1 downto 0 => '0'),
            hprot     => (g_hprot_width-1 downto 0 => '0'),
            htrans    => "00",
            hmastlock => '0');
    signal d_master_haddr     : std_logic_vector(g_addr_width-1 downto 0);
    signal d_master_hsize     : std_logic_vector(2 downto 0);
    signal d_master_hburst    : std_logic_vector(g_hburst_width-1 downto 0);
    signal d_master_hprot     : std_logic_vector(g_hprot_width-1 downto 0);
    signal d_master_htrans    : std_logic_vector(1 downto 0);
    signal d_master_hwrite    : std_logic;
    signal d_master_hmastlock : std_logic;
    
begin
    p_states: process (hresetn_i, hclk_i)
    begin
        if hresetn_i='0' then
            state <= pass;
            hcontrol_s <= c_master_idle;
        elsif rising_edge(hclk_i) then
            -- State Machine:
            case state is
                when store =>
                    if -- Address phase of the waiting
                       -- access is valid:
                       hready_i='1'
                    then
                        state <= pass;
                    end if;
                when pass =>
                    if delay_access_i='1' then
                        hcontrol_s <= hcontrol_i;
                        state <= store;
                    end if;
            end case;
        end if;
    end process;
    p_state_actions: process (hcontrol_s, hcontrol_i, hready_i, state)
    begin
        -- State Actions:
        case state is
            when store=>
                -- To slave:
                hcontrol_o <= hcontrol_s;
                -- To master:
                hready_o <= '0';
            when pass=>
                -- To slave:
                hcontrol_o <= hcontrol_i;
                -- To master:
                hready_o <= hready_i;
        end case;
    end process;
    -- Global Actions combinatorial:
    debug_record(hcontrol_o,
    d_master_haddr,
    d_master_hsize,
    d_master_hburst,
    d_master_hprot,
    d_master_htrans,
    d_master_hwrite,
    d_master_hmastlock
    );
end architecture;
