-- Filename: ahb_multilayer_instage_e.vhd
-- Created by HDL-FSM-Editor at Thu Oct 16 08:47:10 2025
-- The module ahb_multilayer_instage must store the access, if the accessed slave is not available,
-- because the access must be still visible when the accessed slave is connected to this master.
-- In the following example the access acc2 must wait, because the slace is not available:
--
--                                 dataphase addressphase
--                                   acc1      acc2
--                                 extended  valid
--                                     |      |
--                                     V      V
--
-- hcontrol_i               | acc1 | acc2 | acc2 | acc3 | acc3 | acc3 | acc3 | acc3 |
-- hready_o                 |------|______|------|___________________________|------|
--                                            ^
--                                         This access sees hready_o=1, because hready_o is controlled by the slave answering to acc1.
--
-- delay_access_i           |_____________|------|__________________________________|
-- instage state            | idle | idle | idle | store| store| store| idle | idle |
--
--
-- hcontrol_o               | acc1 | acc2 | acc2 | acc2 | acc2 | acc2 | acc3 | acc3 |
-- hready_i                 |------|______|------|_____________|------|______|------|
-- hready_i-controller:             <-  acc1   -> <- slave_interface-> <-  acc2   ->      
--                                        ^                       ^
--                                   dataphase                  addressphase
--                                   acc1                       acc2 valid
--                                                             
--                                           ^ This valid address phase (acc2) after the instage module is ignored,
--                                             because the accessed slave is still connected to another master.
--
library ieee;
use ieee.std_logic_1164.all;
use work.ahb_multilayer_package.all;

entity ahb_multilayer_instage is
    generic (
        g_addr_width   : positive := 16;
        g_hburst_width : natural  := 16;
        g_hprot_width  : natural  := 16;
        g_data_width   : positive :=  8 
    );
    port (
        hresetn_i      : in  std_logic;
        hclk_i         : in  std_logic;
        hcontrol_i     : in  t_ahb_control(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
        hready_o       : out std_logic;
        delay_access_i : in  std_logic;
        hready_i       : in  std_logic;
        hcontrol_o     : out t_ahb_control(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0)) 
        
    );
end entity;
